package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJMeterLogs invokes the pts.GetJMeterLogs API synchronously
func (client *Client) GetJMeterLogs(request *GetJMeterLogsRequest) (response *GetJMeterLogsResponse, err error) {
	response = CreateGetJMeterLogsResponse()
	err = client.DoAction(request, response)
	return
}

// GetJMeterLogsWithChan invokes the pts.GetJMeterLogs API asynchronously
func (client *Client) GetJMeterLogsWithChan(request *GetJMeterLogsRequest) (<-chan *GetJMeterLogsResponse, <-chan error) {
	responseChan := make(chan *GetJMeterLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJMeterLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJMeterLogsWithCallback invokes the pts.GetJMeterLogs API asynchronously
func (client *Client) GetJMeterLogsWithCallback(request *GetJMeterLogsRequest, callback func(response *GetJMeterLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJMeterLogsResponse
		var err error
		defer close(result)
		response, err = client.GetJMeterLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJMeterLogsRequest is the request struct for api GetJMeterLogs
type GetJMeterLogsRequest struct {
	*requests.RpcRequest
	AgentIndex requests.Integer `position:"Query" name:"AgentIndex"`
	ReportId   string           `position:"Query" name:"ReportId"`
	Level      string           `position:"Query" name:"Level"`
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	BeginTime  requests.Integer `position:"Query" name:"BeginTime"`
	Thread     string           `position:"Query" name:"Thread"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Keyword    string           `position:"Query" name:"Keyword"`
}

// GetJMeterLogsResponse is the response struct for api GetJMeterLogs
type GetJMeterLogsResponse struct {
	*responses.BaseResponse
	TotalCount int64                    `json:"TotalCount" xml:"TotalCount"`
	RequestId  string                   `json:"RequestId" xml:"RequestId"`
	Message    string                   `json:"Message" xml:"Message"`
	PageSize   int                      `json:"PageSize" xml:"PageSize"`
	PageNumber int                      `json:"PageNumber" xml:"PageNumber"`
	Code       string                   `json:"Code" xml:"Code"`
	Success    bool                     `json:"Success" xml:"Success"`
	AgentCount int                      `json:"AgentCount" xml:"AgentCount"`
	Logs       []map[string]interface{} `json:"Logs" xml:"Logs"`
}

// CreateGetJMeterLogsRequest creates a request to invoke GetJMeterLogs API
func CreateGetJMeterLogsRequest() (request *GetJMeterLogsRequest) {
	request = &GetJMeterLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "GetJMeterLogs", "", "")
	request.Method = requests.POST
	return
}

// CreateGetJMeterLogsResponse creates a response to parse from GetJMeterLogs response
func CreateGetJMeterLogsResponse() (response *GetJMeterLogsResponse) {
	response = &GetJMeterLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
