package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssignReviewerBySessionGroup invokes the qualitycheck.AssignReviewerBySessionGroup API synchronously
func (client *Client) AssignReviewerBySessionGroup(request *AssignReviewerBySessionGroupRequest) (response *AssignReviewerBySessionGroupResponse, err error) {
	response = CreateAssignReviewerBySessionGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AssignReviewerBySessionGroupWithChan invokes the qualitycheck.AssignReviewerBySessionGroup API asynchronously
func (client *Client) AssignReviewerBySessionGroupWithChan(request *AssignReviewerBySessionGroupRequest) (<-chan *AssignReviewerBySessionGroupResponse, <-chan error) {
	responseChan := make(chan *AssignReviewerBySessionGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssignReviewerBySessionGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssignReviewerBySessionGroupWithCallback invokes the qualitycheck.AssignReviewerBySessionGroup API asynchronously
func (client *Client) AssignReviewerBySessionGroupWithCallback(request *AssignReviewerBySessionGroupRequest, callback func(response *AssignReviewerBySessionGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssignReviewerBySessionGroupResponse
		var err error
		defer close(result)
		response, err = client.AssignReviewerBySessionGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssignReviewerBySessionGroupRequest is the request struct for api AssignReviewerBySessionGroup
type AssignReviewerBySessionGroupRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// AssignReviewerBySessionGroupResponse is the response struct for api AssignReviewerBySessionGroup
type AssignReviewerBySessionGroupResponse struct {
	*responses.BaseResponse
	RequestId      string                                 `json:"RequestId" xml:"RequestId"`
	Success        bool                                   `json:"Success" xml:"Success"`
	Code           string                                 `json:"Code" xml:"Code"`
	Message        string                                 `json:"Message" xml:"Message"`
	HttpStatusCode int                                    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInAssignReviewerBySessionGroup `json:"Messages" xml:"Messages"`
}

// CreateAssignReviewerBySessionGroupRequest creates a request to invoke AssignReviewerBySessionGroup API
func CreateAssignReviewerBySessionGroupRequest() (request *AssignReviewerBySessionGroupRequest) {
	request = &AssignReviewerBySessionGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "AssignReviewerBySessionGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateAssignReviewerBySessionGroupResponse creates a response to parse from AssignReviewerBySessionGroup response
func CreateAssignReviewerBySessionGroupResponse() (response *AssignReviewerBySessionGroupResponse) {
	response = &AssignReviewerBySessionGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
