package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceDeletionProtection invokes the rds.ModifyDBInstanceDeletionProtection API synchronously
func (client *Client) ModifyDBInstanceDeletionProtection(request *ModifyDBInstanceDeletionProtectionRequest) (response *ModifyDBInstanceDeletionProtectionResponse, err error) {
	response = CreateModifyDBInstanceDeletionProtectionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceDeletionProtectionWithChan invokes the rds.ModifyDBInstanceDeletionProtection API asynchronously
func (client *Client) ModifyDBInstanceDeletionProtectionWithChan(request *ModifyDBInstanceDeletionProtectionRequest) (<-chan *ModifyDBInstanceDeletionProtectionResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceDeletionProtectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceDeletionProtection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceDeletionProtectionWithCallback invokes the rds.ModifyDBInstanceDeletionProtection API asynchronously
func (client *Client) ModifyDBInstanceDeletionProtectionWithCallback(request *ModifyDBInstanceDeletionProtectionRequest, callback func(response *ModifyDBInstanceDeletionProtectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceDeletionProtectionResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceDeletionProtection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceDeletionProtectionRequest is the request struct for api ModifyDBInstanceDeletionProtection
type ModifyDBInstanceDeletionProtectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DeletionProtection   requests.Boolean `position:"Query" name:"DeletionProtection"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyDBInstanceDeletionProtectionResponse is the response struct for api ModifyDBInstanceDeletionProtection
type ModifyDBInstanceDeletionProtectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBInstanceDeletionProtectionRequest creates a request to invoke ModifyDBInstanceDeletionProtection API
func CreateModifyDBInstanceDeletionProtectionRequest() (request *ModifyDBInstanceDeletionProtectionRequest) {
	request = &ModifyDBInstanceDeletionProtectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDBInstanceDeletionProtection", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBInstanceDeletionProtectionResponse creates a response to parse from ModifyDBInstanceDeletionProtection response
func CreateModifyDBInstanceDeletionProtectionResponse() (response *ModifyDBInstanceDeletionProtectionResponse) {
	response = &ModifyDBInstanceDeletionProtectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
