package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMultiAccountTagValues invokes the resourcecenter.ListMultiAccountTagValues API synchronously
func (client *Client) ListMultiAccountTagValues(request *ListMultiAccountTagValuesRequest) (response *ListMultiAccountTagValuesResponse, err error) {
	response = CreateListMultiAccountTagValuesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMultiAccountTagValuesWithChan invokes the resourcecenter.ListMultiAccountTagValues API asynchronously
func (client *Client) ListMultiAccountTagValuesWithChan(request *ListMultiAccountTagValuesRequest) (<-chan *ListMultiAccountTagValuesResponse, <-chan error) {
	responseChan := make(chan *ListMultiAccountTagValuesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMultiAccountTagValues(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMultiAccountTagValuesWithCallback invokes the resourcecenter.ListMultiAccountTagValues API asynchronously
func (client *Client) ListMultiAccountTagValuesWithCallback(request *ListMultiAccountTagValuesRequest, callback func(response *ListMultiAccountTagValuesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMultiAccountTagValuesResponse
		var err error
		defer close(result)
		response, err = client.ListMultiAccountTagValues(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMultiAccountTagValuesRequest is the request struct for api ListMultiAccountTagValues
type ListMultiAccountTagValuesRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	Scope      string           `position:"Query" name:"Scope"`
	MatchType  string           `position:"Query" name:"MatchType"`
	TagValue   string           `position:"Query" name:"TagValue"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	TagKey     string           `position:"Query" name:"TagKey"`
}

// ListMultiAccountTagValuesResponse is the response struct for api ListMultiAccountTagValues
type ListMultiAccountTagValuesResponse struct {
	*responses.BaseResponse
	DynamicCode    string   `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string   `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string   `json:"ErrorMessage" xml:"ErrorMessage"`
	NextToken      string   `json:"NextToken" xml:"NextToken"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	TagValues      []string `json:"TagValues" xml:"TagValues"`
}

// CreateListMultiAccountTagValuesRequest creates a request to invoke ListMultiAccountTagValues API
func CreateListMultiAccountTagValuesRequest() (request *ListMultiAccountTagValuesRequest) {
	request = &ListMultiAccountTagValuesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "ListMultiAccountTagValues", "", "")
	request.Method = requests.POST
	return
}

// CreateListMultiAccountTagValuesResponse creates a response to parse from ListMultiAccountTagValues response
func CreateListMultiAccountTagValuesResponse() (response *ListMultiAccountTagValuesResponse) {
	response = &ListMultiAccountTagValuesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
