package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchMultiAccountResources invokes the resourcecenter.SearchMultiAccountResources API synchronously
func (client *Client) SearchMultiAccountResources(request *SearchMultiAccountResourcesRequest) (response *SearchMultiAccountResourcesResponse, err error) {
	response = CreateSearchMultiAccountResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// SearchMultiAccountResourcesWithChan invokes the resourcecenter.SearchMultiAccountResources API asynchronously
func (client *Client) SearchMultiAccountResourcesWithChan(request *SearchMultiAccountResourcesRequest) (<-chan *SearchMultiAccountResourcesResponse, <-chan error) {
	responseChan := make(chan *SearchMultiAccountResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchMultiAccountResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchMultiAccountResourcesWithCallback invokes the resourcecenter.SearchMultiAccountResources API asynchronously
func (client *Client) SearchMultiAccountResourcesWithCallback(request *SearchMultiAccountResourcesRequest, callback func(response *SearchMultiAccountResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchMultiAccountResourcesResponse
		var err error
		defer close(result)
		response, err = client.SearchMultiAccountResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchMultiAccountResourcesRequest is the request struct for api SearchMultiAccountResources
type SearchMultiAccountResourcesRequest struct {
	*requests.RpcRequest
	NextToken     string                                   `position:"Query" name:"NextToken"`
	Scope         string                                   `position:"Query" name:"Scope"`
	SortCriterion SearchMultiAccountResourcesSortCriterion `position:"Query" name:"SortCriterion"  type:"Struct"`
	Filter        *[]SearchMultiAccountResourcesFilter     `position:"Query" name:"Filter"  type:"Repeated"`
	MaxResults    requests.Integer                         `position:"Query" name:"MaxResults"`
}

// SearchMultiAccountResourcesSortCriterion is a repeated param struct in SearchMultiAccountResourcesRequest
type SearchMultiAccountResourcesSortCriterion struct {
	Key   string `name:"Key"`
	Order string `name:"Order"`
}

// SearchMultiAccountResourcesFilter is a repeated param struct in SearchMultiAccountResourcesRequest
type SearchMultiAccountResourcesFilter struct {
	MatchType string    `name:"MatchType"`
	Value     *[]string `name:"Value" type:"Repeated"`
	Key       string    `name:"Key"`
}

// SearchMultiAccountResourcesResponse is the response struct for api SearchMultiAccountResources
type SearchMultiAccountResourcesResponse struct {
	*responses.BaseResponse
	MaxResults int        `json:"MaxResults" xml:"MaxResults"`
	NextToken  string     `json:"NextToken" xml:"NextToken"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Scope      string     `json:"Scope" xml:"Scope"`
	Filters    []Filter   `json:"Filters" xml:"Filters"`
	Resources  []Resource `json:"Resources" xml:"Resources"`
}

// CreateSearchMultiAccountResourcesRequest creates a request to invoke SearchMultiAccountResources API
func CreateSearchMultiAccountResourcesRequest() (request *SearchMultiAccountResourcesRequest) {
	request = &SearchMultiAccountResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "SearchMultiAccountResources", "", "")
	request.Method = requests.POST
	return
}

// CreateSearchMultiAccountResourcesResponse creates a response to parse from SearchMultiAccountResources response
func CreateSearchMultiAccountResourcesResponse() (response *SearchMultiAccountResourcesResponse) {
	response = &SearchMultiAccountResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
