package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTemplates invokes the retailadvqa_public.ListTemplates API synchronously
func (client *Client) ListTemplates(request *ListTemplatesRequest) (response *ListTemplatesResponse, err error) {
	response = CreateListTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListTemplatesWithChan invokes the retailadvqa_public.ListTemplates API asynchronously
func (client *Client) ListTemplatesWithChan(request *ListTemplatesRequest) (<-chan *ListTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTemplatesWithCallback invokes the retailadvqa_public.ListTemplates API asynchronously
func (client *Client) ListTemplatesWithCallback(request *ListTemplatesRequest, callback func(response *ListTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTemplatesRequest is the request struct for api ListTemplates
type ListTemplatesRequest struct {
	*requests.RpcRequest
	IsVariable   requests.Integer `position:"Query" name:"IsVariable"`
	Comefrom     string           `position:"Query" name:"Comefrom"`
	PlatformId   string           `position:"Query" name:"PlatformId"`
	PageNum      requests.Integer `position:"Query" name:"PageNum"`
	ColumnName   string           `position:"Query" name:"ColumnName"`
	AccessId     string           `position:"Query" name:"AccessId"`
	TemplateType requests.Integer `position:"Query" name:"TemplateType"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	TenantId     string           `position:"Query" name:"TenantId"`
	Keyword      string           `position:"Query" name:"Keyword"`
	Order        string           `position:"Query" name:"Order"`
	WorkspaceId  string           `position:"Query" name:"WorkspaceId"`
}

// ListTemplatesResponse is the response struct for api ListTemplates
type ListTemplatesResponse struct {
	*responses.BaseResponse
	ErrorDesc string              `json:"ErrorDesc" xml:"ErrorDesc"`
	ErrorCode string              `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool                `json:"Success" xml:"Success"`
	TraceId   string              `json:"TraceId" xml:"TraceId"`
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Data      DataInListTemplates `json:"Data" xml:"Data"`
}

// CreateListTemplatesRequest creates a request to invoke ListTemplates API
func CreateListTemplatesRequest() (request *ListTemplatesRequest) {
	request = &ListTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ListTemplates", "", "")
	request.Method = requests.GET
	return
}

// CreateListTemplatesResponse creates a response to parse from ListTemplates response
func CreateListTemplatesResponse() (response *ListTemplatesResponse) {
	response = &ListTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
