package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJobHistory invokes the sae.DescribeJobHistory API synchronously
func (client *Client) DescribeJobHistory(request *DescribeJobHistoryRequest) (response *DescribeJobHistoryResponse, err error) {
	response = CreateDescribeJobHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJobHistoryWithChan invokes the sae.DescribeJobHistory API asynchronously
func (client *Client) DescribeJobHistoryWithChan(request *DescribeJobHistoryRequest) (<-chan *DescribeJobHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeJobHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJobHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJobHistoryWithCallback invokes the sae.DescribeJobHistory API asynchronously
func (client *Client) DescribeJobHistoryWithCallback(request *DescribeJobHistoryRequest, callback func(response *DescribeJobHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJobHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeJobHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJobHistoryRequest is the request struct for api DescribeJobHistory
type DescribeJobHistoryRequest struct {
	*requests.RoaRequest
	AppId       string           `position:"Query" name:"AppId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	State       string           `position:"Query" name:"State"`
}

// DescribeJobHistoryResponse is the response struct for api DescribeJobHistory
type DescribeJobHistoryResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Message   string                   `json:"Message" xml:"Message"`
	TraceId   string                   `json:"TraceId" xml:"TraceId"`
	ErrorCode string                   `json:"ErrorCode" xml:"ErrorCode"`
	Code      string                   `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	Data      DataInDescribeJobHistory `json:"Data" xml:"Data"`
}

// CreateDescribeJobHistoryRequest creates a request to invoke DescribeJobHistory API
func CreateDescribeJobHistoryRequest() (request *DescribeJobHistoryRequest) {
	request = &DescribeJobHistoryRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DescribeJobHistory", "/pop/v1/sam/job/describeJobHistory", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeJobHistoryResponse creates a response to parse from DescribeJobHistory response
func CreateDescribeJobHistoryResponse() (response *DescribeJobHistoryResponse) {
	response = &DescribeJobHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
