package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOperator invokes the safe.CreateOperator API synchronously
func (client *Client) CreateOperator(request *CreateOperatorRequest) (response *CreateOperatorResponse, err error) {
	response = CreateCreateOperatorResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOperatorWithChan invokes the safe.CreateOperator API asynchronously
func (client *Client) CreateOperatorWithChan(request *CreateOperatorRequest) (<-chan *CreateOperatorResponse, <-chan error) {
	responseChan := make(chan *CreateOperatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOperator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOperatorWithCallback invokes the safe.CreateOperator API asynchronously
func (client *Client) CreateOperatorWithCallback(request *CreateOperatorRequest, callback func(response *CreateOperatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOperatorResponse
		var err error
		defer close(result)
		response, err = client.CreateOperator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOperatorRequest is the request struct for api CreateOperator
type CreateOperatorRequest struct {
	*requests.RpcRequest
	AuthKey      string           `position:"Body" name:"AuthKey"`
	BgObject     string           `position:"Body" name:"BgObject"`
	ReqTimestamp requests.Integer `position:"Body" name:"ReqTimestamp"`
	Code         string           `position:"Body" name:"Code"`
	BgSystem     string           `position:"Body" name:"BgSystem"`
	NoRisk       requests.Boolean `position:"Body" name:"NoRisk"`
	Name         string           `position:"Body" name:"Name"`
	AuthSign     string           `position:"Body" name:"AuthSign"`
	CurEmpId     string           `position:"Body" name:"CurEmpId"`
	NoCheck      requests.Boolean `position:"Body" name:"NoCheck"`
}

// CreateOperatorResponse is the response struct for api CreateOperator
type CreateOperatorResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateOperatorRequest creates a request to invoke CreateOperator API
func CreateCreateOperatorRequest() (request *CreateOperatorRequest) {
	request = &CreateOperatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "CreateOperator", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateOperatorResponse creates a response to parse from CreateOperator response
func CreateCreateOperatorResponse() (response *CreateOperatorResponse) {
	response = &CreateOperatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
