package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SafeChangeStart invokes the safe.SafeChangeStart API synchronously
func (client *Client) SafeChangeStart(request *SafeChangeStartRequest) (response *SafeChangeStartResponse, err error) {
	response = CreateSafeChangeStartResponse()
	err = client.DoAction(request, response)
	return
}

// SafeChangeStartWithChan invokes the safe.SafeChangeStart API asynchronously
func (client *Client) SafeChangeStartWithChan(request *SafeChangeStartRequest) (<-chan *SafeChangeStartResponse, <-chan error) {
	responseChan := make(chan *SafeChangeStartResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SafeChangeStart(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SafeChangeStartWithCallback invokes the safe.SafeChangeStart API asynchronously
func (client *Client) SafeChangeStartWithCallback(request *SafeChangeStartRequest, callback func(response *SafeChangeStartResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SafeChangeStartResponse
		var err error
		defer close(result)
		response, err = client.SafeChangeStart(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SafeChangeStartRequest is the request struct for api SafeChangeStart
type SafeChangeStartRequest struct {
	*requests.RpcRequest
	TotalBatchNo    requests.Integer `position:"Body" name:"TotalBatchNo"`
	AuthKey         string           `position:"Body" name:"AuthKey"`
	ChangeOptType   string           `position:"Body" name:"ChangeOptType"`
	ChangeObject    string           `position:"Body" name:"ChangeObject"`
	AuthSign        string           `position:"Body" name:"AuthSign"`
	ChangeTitle     string           `position:"Body" name:"ChangeTitle"`
	CreatorEmpId    string           `position:"Body" name:"CreatorEmpId"`
	ChangeStartTime requests.Integer `position:"Body" name:"ChangeStartTime"`
	ReqTimestamp    requests.Integer `position:"Body" name:"ReqTimestamp"`
	ExecutorEmpId   string           `position:"Body" name:"ExecutorEmpId"`
	ChangeEndTime   requests.Integer `position:"Body" name:"ChangeEndTime"`
	CurBatchNo      requests.Integer `position:"Body" name:"CurBatchNo"`
	SourceOrderId   string           `position:"Body" name:"SourceOrderId"`
}

// SafeChangeStartResponse is the response struct for api SafeChangeStart
type SafeChangeStartResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSafeChangeStartRequest creates a request to invoke SafeChangeStart API
func CreateSafeChangeStartRequest() (request *SafeChangeStartRequest) {
	request = &SafeChangeStartRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "SafeChangeStart", "", "")
	request.Method = requests.POST
	return
}

// CreateSafeChangeStartResponse creates a response to parse from SafeChangeStart response
func CreateSafeChangeStartResponse() (response *SafeChangeStartResponse) {
	response = &SafeChangeStartResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
