package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SafeChangeStartApprove invokes the safe.SafeChangeStartApprove API synchronously
func (client *Client) SafeChangeStartApprove(request *SafeChangeStartApproveRequest) (response *SafeChangeStartApproveResponse, err error) {
	response = CreateSafeChangeStartApproveResponse()
	err = client.DoAction(request, response)
	return
}

// SafeChangeStartApproveWithChan invokes the safe.SafeChangeStartApprove API asynchronously
func (client *Client) SafeChangeStartApproveWithChan(request *SafeChangeStartApproveRequest) (<-chan *SafeChangeStartApproveResponse, <-chan error) {
	responseChan := make(chan *SafeChangeStartApproveResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SafeChangeStartApprove(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SafeChangeStartApproveWithCallback invokes the safe.SafeChangeStartApprove API asynchronously
func (client *Client) SafeChangeStartApproveWithCallback(request *SafeChangeStartApproveRequest, callback func(response *SafeChangeStartApproveResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SafeChangeStartApproveResponse
		var err error
		defer close(result)
		response, err = client.SafeChangeStartApprove(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SafeChangeStartApproveRequest is the request struct for api SafeChangeStartApprove
type SafeChangeStartApproveRequest struct {
	*requests.RpcRequest
	AuthKey       string           `position:"Body" name:"AuthKey"`
	ReqTimestamp  requests.Integer `position:"Body" name:"ReqTimestamp"`
	SourceOrderId string           `position:"Body" name:"SourceOrderId"`
	AuthSign      string           `position:"Body" name:"AuthSign"`
	CreatorEmpId  string           `position:"Body" name:"CreatorEmpId"`
	ExtraInfo     string           `position:"Body" name:"ExtraInfo"`
}

// SafeChangeStartApproveResponse is the response struct for api SafeChangeStartApprove
type SafeChangeStartApproveResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSafeChangeStartApproveRequest creates a request to invoke SafeChangeStartApprove API
func CreateSafeChangeStartApproveRequest() (request *SafeChangeStartApproveRequest) {
	request = &SafeChangeStartApproveRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "SafeChangeStartApprove", "", "")
	request.Method = requests.POST
	return
}

// CreateSafeChangeStartApproveResponse creates a response to parse from SafeChangeStartApprove response
func CreateSafeChangeStartApproveResponse() (response *SafeChangeStartApproveResponse) {
	response = &SafeChangeStartApproveResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
