package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRestoreJobs invokes the sas.DescribeRestoreJobs API synchronously
func (client *Client) DescribeRestoreJobs(request *DescribeRestoreJobsRequest) (response *DescribeRestoreJobsResponse, err error) {
	response = CreateDescribeRestoreJobsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRestoreJobsWithChan invokes the sas.DescribeRestoreJobs API asynchronously
func (client *Client) DescribeRestoreJobsWithChan(request *DescribeRestoreJobsRequest) (<-chan *DescribeRestoreJobsResponse, <-chan error) {
	responseChan := make(chan *DescribeRestoreJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRestoreJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRestoreJobsWithCallback invokes the sas.DescribeRestoreJobs API asynchronously
func (client *Client) DescribeRestoreJobsWithCallback(request *DescribeRestoreJobsRequest, callback func(response *DescribeRestoreJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRestoreJobsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRestoreJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRestoreJobsRequest is the request struct for api DescribeRestoreJobs
type DescribeRestoreJobsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	MachineRemark   string           `position:"Query" name:"MachineRemark"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	Status          string           `position:"Query" name:"Status"`
}

// DescribeRestoreJobsResponse is the response struct for api DescribeRestoreJobs
type DescribeRestoreJobsResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	PageInfo    PageInfo     `json:"PageInfo" xml:"PageInfo"`
	RestoreJobs []RestoreJob `json:"RestoreJobs" xml:"RestoreJobs"`
}

// CreateDescribeRestoreJobsRequest creates a request to invoke DescribeRestoreJobs API
func CreateDescribeRestoreJobsRequest() (request *DescribeRestoreJobsRequest) {
	request = &DescribeRestoreJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeRestoreJobs", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRestoreJobsResponse creates a response to parse from DescribeRestoreJobs response
func CreateDescribeRestoreJobsResponse() (response *DescribeRestoreJobsResponse) {
	response = &DescribeRestoreJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
