package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCheckResult invokes the sas.ListCheckResult API synchronously
func (client *Client) ListCheckResult(request *ListCheckResultRequest) (response *ListCheckResultResponse, err error) {
	response = CreateListCheckResultResponse()
	err = client.DoAction(request, response)
	return
}

// ListCheckResultWithChan invokes the sas.ListCheckResult API asynchronously
func (client *Client) ListCheckResultWithChan(request *ListCheckResultRequest) (<-chan *ListCheckResultResponse, <-chan error) {
	responseChan := make(chan *ListCheckResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCheckResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCheckResultWithCallback invokes the sas.ListCheckResult API asynchronously
func (client *Client) ListCheckResultWithCallback(request *ListCheckResultRequest, callback func(response *ListCheckResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCheckResultResponse
		var err error
		defer close(result)
		response, err = client.ListCheckResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCheckResultRequest is the request struct for api ListCheckResult
type ListCheckResultRequest struct {
	*requests.RpcRequest
	InstanceSubTypes *[]string        `position:"Query" name:"InstanceSubTypes"  type:"Repeated"`
	StandardIds      *[]string        `position:"Query" name:"StandardIds"  type:"Repeated"`
	RiskLevels       *[]string        `position:"Query" name:"RiskLevels"  type:"Repeated"`
	InstanceTypes    *[]string        `position:"Query" name:"InstanceTypes"  type:"Repeated"`
	CheckKey         string           `position:"Query" name:"CheckKey"`
	SourceIp         string           `position:"Query" name:"SourceIp"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	Lang             string           `position:"Query" name:"Lang"`
	Vendors          *[]string        `position:"Query" name:"Vendors"  type:"Repeated"`
	CurrentPage      requests.Integer `position:"Query" name:"CurrentPage"`
	RequirementIds   *[]string        `position:"Query" name:"RequirementIds"  type:"Repeated"`
	SortTypes        *[]string        `position:"Query" name:"SortTypes"  type:"Repeated"`
	InstanceIds      *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Statuses         *[]string        `position:"Query" name:"Statuses"  type:"Repeated"`
}

// ListCheckResultResponse is the response struct for api ListCheckResult
type ListCheckResultResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo     `json:"PageInfo" xml:"PageInfo"`
	Checks    []ChecksItem `json:"Checks" xml:"Checks"`
}

// CreateListCheckResultRequest creates a request to invoke ListCheckResult API
func CreateListCheckResultRequest() (request *ListCheckResultRequest) {
	request = &ListCheckResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ListCheckResult", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCheckResultResponse creates a response to parse from ListCheckResult response
func CreateListCheckResultResponse() (response *ListCheckResultResponse) {
	response = &ListCheckResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
