package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateVuls invokes the sas.OperateVuls API synchronously
func (client *Client) OperateVuls(request *OperateVulsRequest) (response *OperateVulsResponse, err error) {
	response = CreateOperateVulsResponse()
	err = client.DoAction(request, response)
	return
}

// OperateVulsWithChan invokes the sas.OperateVuls API asynchronously
func (client *Client) OperateVulsWithChan(request *OperateVulsRequest) (<-chan *OperateVulsResponse, <-chan error) {
	responseChan := make(chan *OperateVulsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateVuls(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateVulsWithCallback invokes the sas.OperateVuls API asynchronously
func (client *Client) OperateVulsWithCallback(request *OperateVulsRequest, callback func(response *OperateVulsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateVulsResponse
		var err error
		defer close(result)
		response, err = client.OperateVuls(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateVulsRequest is the request struct for api OperateVuls
type OperateVulsRequest struct {
	*requests.RpcRequest
	Type        string    `position:"Query" name:"Type"`
	VulNames    *[]string `position:"Query" name:"VulNames"  type:"Repeated"`
	SourceIp    string    `position:"Query" name:"SourceIp"`
	OperateType string    `position:"Query" name:"OperateType"`
	Uuids       *[]string `position:"Query" name:"Uuids"  type:"Repeated"`
}

// OperateVulsResponse is the response struct for api OperateVuls
type OperateVulsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateVulsRequest creates a request to invoke OperateVuls API
func CreateOperateVulsRequest() (request *OperateVulsRequest) {
	request = &OperateVulsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "OperateVuls", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOperateVulsResponse creates a response to parse from OperateVuls response
func CreateOperateVulsResponse() (response *OperateVulsResponse) {
	response = &OperateVulsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
