package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateEnableJobs invokes the schedulerx3.OperateEnableJobs API synchronously
func (client *Client) OperateEnableJobs(request *OperateEnableJobsRequest) (response *OperateEnableJobsResponse, err error) {
	response = CreateOperateEnableJobsResponse()
	err = client.DoAction(request, response)
	return
}

// OperateEnableJobsWithChan invokes the schedulerx3.OperateEnableJobs API asynchronously
func (client *Client) OperateEnableJobsWithChan(request *OperateEnableJobsRequest) (<-chan *OperateEnableJobsResponse, <-chan error) {
	responseChan := make(chan *OperateEnableJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateEnableJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateEnableJobsWithCallback invokes the schedulerx3.OperateEnableJobs API asynchronously
func (client *Client) OperateEnableJobsWithCallback(request *OperateEnableJobsRequest, callback func(response *OperateEnableJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateEnableJobsResponse
		var err error
		defer close(result)
		response, err = client.OperateEnableJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateEnableJobsRequest is the request struct for api OperateEnableJobs
type OperateEnableJobsRequest struct {
	*requests.RpcRequest
	MseSessionId string    `position:"Query" name:"MseSessionId"`
	ClusterId    string    `position:"Body" name:"ClusterId"`
	AppName      string    `position:"Body" name:"AppName"`
	JobIds       *[]string `position:"Body" name:"JobIds"  type:"Json"`
}

// OperateEnableJobsResponse is the response struct for api OperateEnableJobs
type OperateEnableJobsResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateOperateEnableJobsRequest creates a request to invoke OperateEnableJobs API
func CreateOperateEnableJobsRequest() (request *OperateEnableJobsRequest) {
	request = &OperateEnableJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "OperateEnableJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateEnableJobsResponse creates a response to parse from OperateEnableJobs response
func CreateOperateEnableJobsResponse() (response *OperateEnableJobsResponse) {
	response = &OperateEnableJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
