package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayInfo invokes the sgw.DescribeGatewayInfo API synchronously
func (client *Client) DescribeGatewayInfo(request *DescribeGatewayInfoRequest) (response *DescribeGatewayInfoResponse, err error) {
	response = CreateDescribeGatewayInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayInfoWithChan invokes the sgw.DescribeGatewayInfo API asynchronously
func (client *Client) DescribeGatewayInfoWithChan(request *DescribeGatewayInfoRequest) (<-chan *DescribeGatewayInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayInfoWithCallback invokes the sgw.DescribeGatewayInfo API asynchronously
func (client *Client) DescribeGatewayInfoWithCallback(request *DescribeGatewayInfoRequest, callback func(response *DescribeGatewayInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayInfoRequest is the request struct for api DescribeGatewayInfo
type DescribeGatewayInfoRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeGatewayInfoResponse is the response struct for api DescribeGatewayInfo
type DescribeGatewayInfoResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	GatewayInfos GatewayInfos `json:"GatewayInfos" xml:"GatewayInfos"`
}

// CreateDescribeGatewayInfoRequest creates a request to invoke DescribeGatewayInfo API
func CreateDescribeGatewayInfoRequest() (request *DescribeGatewayInfoRequest) {
	request = &DescribeGatewayInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayInfo", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayInfoResponse creates a response to parse from DescribeGatewayInfo response
func CreateDescribeGatewayInfoResponse() (response *DescribeGatewayInfoResponse) {
	response = &DescribeGatewayInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
