package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachKeyPair invokes the swas_open.DetachKeyPair API synchronously
func (client *Client) DetachKeyPair(request *DetachKeyPairRequest) (response *DetachKeyPairResponse, err error) {
	response = CreateDetachKeyPairResponse()
	err = client.DoAction(request, response)
	return
}

// DetachKeyPairWithChan invokes the swas_open.DetachKeyPair API asynchronously
func (client *Client) DetachKeyPairWithChan(request *DetachKeyPairRequest) (<-chan *DetachKeyPairResponse, <-chan error) {
	responseChan := make(chan *DetachKeyPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachKeyPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachKeyPairWithCallback invokes the swas_open.DetachKeyPair API asynchronously
func (client *Client) DetachKeyPairWithCallback(request *DetachKeyPairRequest, callback func(response *DetachKeyPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachKeyPairResponse
		var err error
		defer close(result)
		response, err = client.DetachKeyPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachKeyPairRequest is the request struct for api DetachKeyPair
type DetachKeyPairRequest struct {
	*requests.RpcRequest
	ClientToken string    `position:"Query" name:"ClientToken"`
	KeyPairName string    `position:"Query" name:"KeyPairName"`
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// DetachKeyPairResponse is the response struct for api DetachKeyPair
type DetachKeyPairResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	FailCount  int      `json:"FailCount" xml:"FailCount"`
	Results    []Result `json:"Results" xml:"Results"`
}

// CreateDetachKeyPairRequest creates a request to invoke DetachKeyPair API
func CreateDetachKeyPairRequest() (request *DetachKeyPairRequest) {
	request = &DetachKeyPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DetachKeyPair", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachKeyPairResponse creates a response to parse from DetachKeyPair response
func CreateDetachKeyPairResponse() (response *DetachKeyPairResponse) {
	response = &DetachKeyPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
