package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartNotary invokes the trademark.StartNotary API synchronously
// api document: https://help.aliyun.com/api/trademark/startnotary.html
func (client *Client) StartNotary(request *StartNotaryRequest) (response *StartNotaryResponse, err error) {
	response = CreateStartNotaryResponse()
	err = client.DoAction(request, response)
	return
}

// StartNotaryWithChan invokes the trademark.StartNotary API asynchronously
// api document: https://help.aliyun.com/api/trademark/startnotary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartNotaryWithChan(request *StartNotaryRequest) (<-chan *StartNotaryResponse, <-chan error) {
	responseChan := make(chan *StartNotaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartNotary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartNotaryWithCallback invokes the trademark.StartNotary API asynchronously
// api document: https://help.aliyun.com/api/trademark/startnotary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartNotaryWithCallback(request *StartNotaryRequest, callback func(response *StartNotaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartNotaryResponse
		var err error
		defer close(result)
		response, err = client.StartNotary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartNotaryRequest is the request struct for api StartNotary
type StartNotaryRequest struct {
	*requests.RpcRequest
	NotaryOrderId requests.Integer `position:"Query" name:"NotaryOrderId"`
}

// StartNotaryResponse is the response struct for api StartNotary
type StartNotaryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	NotaryUrl string `json:"NotaryUrl" xml:"NotaryUrl"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateStartNotaryRequest creates a request to invoke StartNotary API
func CreateStartNotaryRequest() (request *StartNotaryRequest) {
	request = &StartNotaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "StartNotary", "trademark", "openAPI")
	return
}

// CreateStartNotaryResponse creates a response to parse from StartNotary response
func CreateStartNotaryResponse() (response *StartNotaryResponse) {
	response = &StartNotaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
