package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUisConnections invokes the uis.DescribeUisConnections API synchronously
// api document: https://help.aliyun.com/api/uis/describeuisconnections.html
func (client *Client) DescribeUisConnections(request *DescribeUisConnectionsRequest) (response *DescribeUisConnectionsResponse, err error) {
	response = CreateDescribeUisConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUisConnectionsWithChan invokes the uis.DescribeUisConnections API asynchronously
// api document: https://help.aliyun.com/api/uis/describeuisconnections.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUisConnectionsWithChan(request *DescribeUisConnectionsRequest) (<-chan *DescribeUisConnectionsResponse, <-chan error) {
	responseChan := make(chan *DescribeUisConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUisConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUisConnectionsWithCallback invokes the uis.DescribeUisConnections API asynchronously
// api document: https://help.aliyun.com/api/uis/describeuisconnections.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUisConnectionsWithCallback(request *DescribeUisConnectionsRequest, callback func(response *DescribeUisConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUisConnectionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeUisConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUisConnectionsRequest is the request struct for api DescribeUisConnections
type DescribeUisConnectionsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	UisConnectionId      string           `position:"Query" name:"UisConnectionId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeUisConnectionsResponse is the response struct for api DescribeUisConnections
type DescribeUisConnectionsResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	PageNumber     int            `json:"PageNumber" xml:"PageNumber"`
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	UisConnections UisConnections `json:"UisConnections" xml:"UisConnections"`
}

// CreateDescribeUisConnectionsRequest creates a request to invoke DescribeUisConnections API
func CreateDescribeUisConnectionsRequest() (request *DescribeUisConnectionsRequest) {
	request = &DescribeUisConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DescribeUisConnections", "uis", "openAPI")
	return
}

// CreateDescribeUisConnectionsResponse creates a response to parse from DescribeUisConnections response
func CreateDescribeUisConnectionsResponse() (response *DescribeUisConnectionsResponse) {
	response = &DescribeUisConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
