package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendTaokeInfo invokes the unimkt.SendTaokeInfo API synchronously
func (client *Client) SendTaokeInfo(request *SendTaokeInfoRequest) (response *SendTaokeInfoResponse, err error) {
	response = CreateSendTaokeInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SendTaokeInfoWithChan invokes the unimkt.SendTaokeInfo API asynchronously
func (client *Client) SendTaokeInfoWithChan(request *SendTaokeInfoRequest) (<-chan *SendTaokeInfoResponse, <-chan error) {
	responseChan := make(chan *SendTaokeInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendTaokeInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendTaokeInfoWithCallback invokes the unimkt.SendTaokeInfo API asynchronously
func (client *Client) SendTaokeInfoWithCallback(request *SendTaokeInfoRequest, callback func(response *SendTaokeInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendTaokeInfoResponse
		var err error
		defer close(result)
		response, err = client.SendTaokeInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendTaokeInfoRequest is the request struct for api SendTaokeInfo
type SendTaokeInfoRequest struct {
	*requests.RpcRequest
	ProductId       string `position:"Body" name:"ProductId"`
	Gender          string `position:"Body" name:"Gender"`
	City            string `position:"Body" name:"City"`
	UserId          string `position:"Body" name:"UserId"`
	Mac             string `position:"Body" name:"Mac"`
	Province        string `position:"Body" name:"Province"`
	ProductTitle    string `position:"Body" name:"ProductTitle"`
	BrandId         string `position:"Body" name:"BrandId"`
	SellPrice       string `position:"Body" name:"SellPrice"`
	Plat            string `position:"Body" name:"Plat"`
	ComponentId     string `position:"Body" name:"ComponentId"`
	Address         string `position:"Body" name:"Address"`
	Ip              string `position:"Body" name:"Ip"`
	MediaId         string `position:"Body" name:"MediaId"`
	Phone           string `position:"Body" name:"Phone"`
	V               string `position:"Body" name:"V"`
	EnvironmentType string `position:"Body" name:"EnvironmentType"`
	District        string `position:"Body" name:"District"`
	Imei            string `position:"Body" name:"Imei"`
	PayPrice        string `position:"Body" name:"PayPrice"`
	ChannelId       string `position:"Body" name:"ChannelId"`
	Age             string `position:"Body" name:"Age"`
	Status          string `position:"Body" name:"Status"`
}

// SendTaokeInfoResponse is the response struct for api SendTaokeInfo
type SendTaokeInfoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateSendTaokeInfoRequest creates a request to invoke SendTaokeInfo API
func CreateSendTaokeInfoRequest() (request *SendTaokeInfoRequest) {
	request = &SendTaokeInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "SendTaokeInfo", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendTaokeInfoResponse creates a response to parse from SendTaokeInfo response
func CreateSendTaokeInfoResponse() (response *SendTaokeInfoResponse) {
	response = &SendTaokeInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
