package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ParseConnector invokes the ververica.ParseConnector API synchronously
func (client *Client) ParseConnector(request *ParseConnectorRequest) (response *ParseConnectorResponse, err error) {
	response = CreateParseConnectorResponse()
	err = client.DoAction(request, response)
	return
}

// ParseConnectorWithChan invokes the ververica.ParseConnector API asynchronously
func (client *Client) ParseConnectorWithChan(request *ParseConnectorRequest) (<-chan *ParseConnectorResponse, <-chan error) {
	responseChan := make(chan *ParseConnectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ParseConnector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ParseConnectorWithCallback invokes the ververica.ParseConnector API asynchronously
func (client *Client) ParseConnectorWithCallback(request *ParseConnectorRequest, callback func(response *ParseConnectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ParseConnectorResponse
		var err error
		defer close(result)
		response, err = client.ParseConnector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ParseConnectorRequest is the request struct for api ParseConnector
type ParseConnectorRequest struct {
	*requests.RoaRequest
	Workspace  string `position:"Path" name:"workspace"`
	ParamsJson string `position:"Body" name:"paramsJson"`
	Namespace  string `position:"Path" name:"namespace"`
}

// ParseConnectorResponse is the response struct for api ParseConnector
type ParseConnectorResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateParseConnectorRequest creates a request to invoke ParseConnector API
func CreateParseConnectorRequest() (request *ParseConnectorRequest) {
	request = &ParseConnectorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ParseConnector", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/connectors:analyze-jars", "", "")
	request.Method = requests.POST
	return
}

// CreateParseConnectorResponse creates a response to parse from ParseConnector response
func CreateParseConnectorResponse() (response *ParseConnectorResponse) {
	response = &ParseConnectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
