package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportDataReflowDataList invokes the viapi_regen.ExportDataReflowDataList API synchronously
func (client *Client) ExportDataReflowDataList(request *ExportDataReflowDataListRequest) (response *ExportDataReflowDataListResponse, err error) {
	response = CreateExportDataReflowDataListResponse()
	err = client.DoAction(request, response)
	return
}

// ExportDataReflowDataListWithChan invokes the viapi_regen.ExportDataReflowDataList API asynchronously
func (client *Client) ExportDataReflowDataListWithChan(request *ExportDataReflowDataListRequest) (<-chan *ExportDataReflowDataListResponse, <-chan error) {
	responseChan := make(chan *ExportDataReflowDataListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportDataReflowDataList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportDataReflowDataListWithCallback invokes the viapi_regen.ExportDataReflowDataList API asynchronously
func (client *Client) ExportDataReflowDataListWithCallback(request *ExportDataReflowDataListRequest, callback func(response *ExportDataReflowDataListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportDataReflowDataListResponse
		var err error
		defer close(result)
		response, err = client.ExportDataReflowDataList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportDataReflowDataListRequest is the request struct for api ExportDataReflowDataList
type ExportDataReflowDataListRequest struct {
	*requests.RpcRequest
	FileType  string           `position:"Body" name:"FileType"`
	StartTime requests.Integer `position:"Body" name:"StartTime"`
	ImageName string           `position:"Body" name:"ImageName"`
	EndTime   requests.Integer `position:"Body" name:"EndTime"`
	ServiceId requests.Integer `position:"Body" name:"ServiceId"`
	Category  string           `position:"Body" name:"Category"`
}

// ExportDataReflowDataListResponse is the response struct for api ExportDataReflowDataList
type ExportDataReflowDataListResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateExportDataReflowDataListRequest creates a request to invoke ExportDataReflowDataList API
func CreateExportDataReflowDataListRequest() (request *ExportDataReflowDataListRequest) {
	request = &ExportDataReflowDataListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "ExportDataReflowDataList", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExportDataReflowDataListResponse creates a response to parse from ExportDataReflowDataList response
func CreateExportDataReflowDataListResponse() (response *ExportDataReflowDataListResponse) {
	response = &ExportDataReflowDataListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
