package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExpressConnectTrafficQos invokes the vpc.DeleteExpressConnectTrafficQos API synchronously
func (client *Client) DeleteExpressConnectTrafficQos(request *DeleteExpressConnectTrafficQosRequest) (response *DeleteExpressConnectTrafficQosResponse, err error) {
	response = CreateDeleteExpressConnectTrafficQosResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExpressConnectTrafficQosWithChan invokes the vpc.DeleteExpressConnectTrafficQos API asynchronously
func (client *Client) DeleteExpressConnectTrafficQosWithChan(request *DeleteExpressConnectTrafficQosRequest) (<-chan *DeleteExpressConnectTrafficQosResponse, <-chan error) {
	responseChan := make(chan *DeleteExpressConnectTrafficQosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExpressConnectTrafficQos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExpressConnectTrafficQosWithCallback invokes the vpc.DeleteExpressConnectTrafficQos API asynchronously
func (client *Client) DeleteExpressConnectTrafficQosWithCallback(request *DeleteExpressConnectTrafficQosRequest, callback func(response *DeleteExpressConnectTrafficQosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExpressConnectTrafficQosResponse
		var err error
		defer close(result)
		response, err = client.DeleteExpressConnectTrafficQos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExpressConnectTrafficQosRequest is the request struct for api DeleteExpressConnectTrafficQos
type DeleteExpressConnectTrafficQosRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	QosId                string           `position:"Query" name:"QosId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteExpressConnectTrafficQosResponse is the response struct for api DeleteExpressConnectTrafficQos
type DeleteExpressConnectTrafficQosResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteExpressConnectTrafficQosRequest creates a request to invoke DeleteExpressConnectTrafficQos API
func CreateDeleteExpressConnectTrafficQosRequest() (request *DeleteExpressConnectTrafficQosRequest) {
	request = &DeleteExpressConnectTrafficQosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteExpressConnectTrafficQos", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteExpressConnectTrafficQosResponse creates a response to parse from DeleteExpressConnectTrafficQos response
func CreateDeleteExpressConnectTrafficQosResponse() (response *DeleteExpressConnectTrafficQosResponse) {
	response = &DeleteExpressConnectTrafficQosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
