package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePublicIpAddressPoolCidrBlock invokes the vpc.DeletePublicIpAddressPoolCidrBlock API synchronously
func (client *Client) DeletePublicIpAddressPoolCidrBlock(request *DeletePublicIpAddressPoolCidrBlockRequest) (response *DeletePublicIpAddressPoolCidrBlockResponse, err error) {
	response = CreateDeletePublicIpAddressPoolCidrBlockResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePublicIpAddressPoolCidrBlockWithChan invokes the vpc.DeletePublicIpAddressPoolCidrBlock API asynchronously
func (client *Client) DeletePublicIpAddressPoolCidrBlockWithChan(request *DeletePublicIpAddressPoolCidrBlockRequest) (<-chan *DeletePublicIpAddressPoolCidrBlockResponse, <-chan error) {
	responseChan := make(chan *DeletePublicIpAddressPoolCidrBlockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePublicIpAddressPoolCidrBlock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePublicIpAddressPoolCidrBlockWithCallback invokes the vpc.DeletePublicIpAddressPoolCidrBlock API asynchronously
func (client *Client) DeletePublicIpAddressPoolCidrBlockWithCallback(request *DeletePublicIpAddressPoolCidrBlockRequest, callback func(response *DeletePublicIpAddressPoolCidrBlockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePublicIpAddressPoolCidrBlockResponse
		var err error
		defer close(result)
		response, err = client.DeletePublicIpAddressPoolCidrBlock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePublicIpAddressPoolCidrBlockRequest is the request struct for api DeletePublicIpAddressPoolCidrBlock
type DeletePublicIpAddressPoolCidrBlockRequest struct {
	*requests.RpcRequest
	PublicIpAddressPoolId string           `position:"Query" name:"PublicIpAddressPoolId"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	DryRun                requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	CidrBlock             string           `position:"Query" name:"CidrBlock"`
}

// DeletePublicIpAddressPoolCidrBlockResponse is the response struct for api DeletePublicIpAddressPoolCidrBlock
type DeletePublicIpAddressPoolCidrBlockResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePublicIpAddressPoolCidrBlockRequest creates a request to invoke DeletePublicIpAddressPoolCidrBlock API
func CreateDeletePublicIpAddressPoolCidrBlockRequest() (request *DeletePublicIpAddressPoolCidrBlockRequest) {
	request = &DeletePublicIpAddressPoolCidrBlockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeletePublicIpAddressPoolCidrBlock", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeletePublicIpAddressPoolCidrBlockResponse creates a response to parse from DeletePublicIpAddressPoolCidrBlock response
func CreateDeletePublicIpAddressPoolCidrBlockResponse() (response *DeletePublicIpAddressPoolCidrBlockResponse) {
	response = &DeletePublicIpAddressPoolCidrBlockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
