package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIpsecServerLogs invokes the vpc.ListIpsecServerLogs API synchronously
func (client *Client) ListIpsecServerLogs(request *ListIpsecServerLogsRequest) (response *ListIpsecServerLogsResponse, err error) {
	response = CreateListIpsecServerLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListIpsecServerLogsWithChan invokes the vpc.ListIpsecServerLogs API asynchronously
func (client *Client) ListIpsecServerLogsWithChan(request *ListIpsecServerLogsRequest) (<-chan *ListIpsecServerLogsResponse, <-chan error) {
	responseChan := make(chan *ListIpsecServerLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIpsecServerLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIpsecServerLogsWithCallback invokes the vpc.ListIpsecServerLogs API asynchronously
func (client *Client) ListIpsecServerLogsWithCallback(request *ListIpsecServerLogsRequest, callback func(response *ListIpsecServerLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIpsecServerLogsResponse
		var err error
		defer close(result)
		response, err = client.ListIpsecServerLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIpsecServerLogsRequest is the request struct for api ListIpsecServerLogs
type ListIpsecServerLogsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CallerBid       string           `position:"Query" name:"callerBid"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	MinutePeriod    requests.Integer `position:"Query" name:"MinutePeriod"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	From            requests.Integer `position:"Query" name:"From"`
	To              requests.Integer `position:"Query" name:"To"`
	IpsecServerId   string           `position:"Query" name:"IpsecServerId"`
}

// ListIpsecServerLogsResponse is the response struct for api ListIpsecServerLogs
type ListIpsecServerLogsResponse struct {
	*responses.BaseResponse
	PageSize    int      `json:"PageSize" xml:"PageSize"`
	PageNumber  int      `json:"PageNumber" xml:"PageNumber"`
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	Count       int      `json:"Count" xml:"Count"`
	IsCompleted bool     `json:"IsCompleted" xml:"IsCompleted"`
	Data        []string `json:"Data" xml:"Data"`
}

// CreateListIpsecServerLogsRequest creates a request to invoke ListIpsecServerLogs API
func CreateListIpsecServerLogsRequest() (request *ListIpsecServerLogsRequest) {
	request = &ListIpsecServerLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListIpsecServerLogs", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListIpsecServerLogsResponse creates a response to parse from ListIpsecServerLogs response
func CreateListIpsecServerLogsResponse() (response *ListIpsecServerLogsResponse) {
	response = &ListIpsecServerLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
