package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosisTasks invokes the adb.DescribeDiagnosisTasks API synchronously
func (client *Client) DescribeDiagnosisTasks(request *DescribeDiagnosisTasksRequest) (response *DescribeDiagnosisTasksResponse, err error) {
	response = CreateDescribeDiagnosisTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosisTasksWithChan invokes the adb.DescribeDiagnosisTasks API asynchronously
func (client *Client) DescribeDiagnosisTasksWithChan(request *DescribeDiagnosisTasksRequest) (<-chan *DescribeDiagnosisTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosisTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosisTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosisTasksWithCallback invokes the adb.DescribeDiagnosisTasks API asynchronously
func (client *Client) DescribeDiagnosisTasksWithCallback(request *DescribeDiagnosisTasksRequest, callback func(response *DescribeDiagnosisTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosisTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosisTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosisTasksRequest is the request struct for api DescribeDiagnosisTasks
type DescribeDiagnosisTasksRequest struct {
	*requests.RpcRequest
	DBClusterId string           `position:"Query" name:"DBClusterId"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	ProcessId   string           `position:"Query" name:"ProcessId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Host        string           `position:"Query" name:"Host"`
	State       string           `position:"Query" name:"State"`
	StageId     string           `position:"Query" name:"StageId"`
	Order       string           `position:"Query" name:"Order"`
}

// DescribeDiagnosisTasksResponse is the response struct for api DescribeDiagnosisTasks
type DescribeDiagnosisTasksResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	TaskList   []SqlTasks `json:"TaskList" xml:"TaskList"`
}

// CreateDescribeDiagnosisTasksRequest creates a request to invoke DescribeDiagnosisTasks API
func CreateDescribeDiagnosisTasksRequest() (request *DescribeDiagnosisTasksRequest) {
	request = &DescribeDiagnosisTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDiagnosisTasks", "ads", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDiagnosisTasksResponse creates a response to parse from DescribeDiagnosisTasks response
func CreateDescribeDiagnosisTasksResponse() (response *DescribeDiagnosisTasksResponse) {
	response = &DescribeDiagnosisTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
