package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWhiteListAuthorize invokes the aegis.DescribeWhiteListAuthorize API synchronously
// api document: https://help.aliyun.com/api/aegis/describewhitelistauthorize.html
func (client *Client) DescribeWhiteListAuthorize(request *DescribeWhiteListAuthorizeRequest) (response *DescribeWhiteListAuthorizeResponse, err error) {
	response = CreateDescribeWhiteListAuthorizeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWhiteListAuthorizeWithChan invokes the aegis.DescribeWhiteListAuthorize API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewhitelistauthorize.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWhiteListAuthorizeWithChan(request *DescribeWhiteListAuthorizeRequest) (<-chan *DescribeWhiteListAuthorizeResponse, <-chan error) {
	responseChan := make(chan *DescribeWhiteListAuthorizeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWhiteListAuthorize(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWhiteListAuthorizeWithCallback invokes the aegis.DescribeWhiteListAuthorize API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewhitelistauthorize.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWhiteListAuthorizeWithCallback(request *DescribeWhiteListAuthorizeRequest, callback func(response *DescribeWhiteListAuthorizeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWhiteListAuthorizeResponse
		var err error
		defer close(result)
		response, err = client.DescribeWhiteListAuthorize(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWhiteListAuthorizeRequest is the request struct for api DescribeWhiteListAuthorize
type DescribeWhiteListAuthorizeRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeWhiteListAuthorizeResponse is the response struct for api DescribeWhiteListAuthorize
type DescribeWhiteListAuthorizeResponse struct {
	*responses.BaseResponse
	RequestId             string `json:"RequestId" xml:"RequestId"`
	AvailableAuthorizeNum int    `json:"AvailableAuthorizeNum" xml:"AvailableAuthorizeNum"`
}

// CreateDescribeWhiteListAuthorizeRequest creates a request to invoke DescribeWhiteListAuthorize API
func CreateDescribeWhiteListAuthorizeRequest() (request *DescribeWhiteListAuthorizeRequest) {
	request = &DescribeWhiteListAuthorizeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeWhiteListAuthorize", "vipaegis", "openAPI")
	return
}

// CreateDescribeWhiteListAuthorizeResponse creates a response to parse from DescribeWhiteListAuthorize response
func CreateDescribeWhiteListAuthorizeResponse() (response *DescribeWhiteListAuthorizeResponse) {
	response = &DescribeWhiteListAuthorizeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
