package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableSystemRule invokes the ahas_openapi.DisableSystemRule API synchronously
func (client *Client) DisableSystemRule(request *DisableSystemRuleRequest) (response *DisableSystemRuleResponse, err error) {
	response = CreateDisableSystemRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableSystemRuleWithChan invokes the ahas_openapi.DisableSystemRule API asynchronously
func (client *Client) DisableSystemRuleWithChan(request *DisableSystemRuleRequest) (<-chan *DisableSystemRuleResponse, <-chan error) {
	responseChan := make(chan *DisableSystemRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableSystemRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableSystemRuleWithCallback invokes the ahas_openapi.DisableSystemRule API asynchronously
func (client *Client) DisableSystemRuleWithCallback(request *DisableSystemRuleRequest, callback func(response *DisableSystemRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableSystemRuleResponse
		var err error
		defer close(result)
		response, err = client.DisableSystemRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableSystemRuleRequest is the request struct for api DisableSystemRule
type DisableSystemRuleRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	RuleId       requests.Integer `position:"Query" name:"RuleId"`
}

// DisableSystemRuleResponse is the response struct for api DisableSystemRule
type DisableSystemRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDisableSystemRuleRequest creates a request to invoke DisableSystemRule API
func CreateDisableSystemRuleRequest() (request *DisableSystemRuleRequest) {
	request = &DisableSystemRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "DisableSystemRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableSystemRuleResponse creates a response to parse from DisableSystemRule response
func CreateDisableSystemRuleResponse() (response *DisableSystemRuleResponse) {
	response = &DisableSystemRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
