package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDegradeRulesOfApp invokes the ahas_openapi.ListDegradeRulesOfApp API synchronously
func (client *Client) ListDegradeRulesOfApp(request *ListDegradeRulesOfAppRequest) (response *ListDegradeRulesOfAppResponse, err error) {
	response = CreateListDegradeRulesOfAppResponse()
	err = client.DoAction(request, response)
	return
}

// ListDegradeRulesOfAppWithChan invokes the ahas_openapi.ListDegradeRulesOfApp API asynchronously
func (client *Client) ListDegradeRulesOfAppWithChan(request *ListDegradeRulesOfAppRequest) (<-chan *ListDegradeRulesOfAppResponse, <-chan error) {
	responseChan := make(chan *ListDegradeRulesOfAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDegradeRulesOfApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDegradeRulesOfAppWithCallback invokes the ahas_openapi.ListDegradeRulesOfApp API asynchronously
func (client *Client) ListDegradeRulesOfAppWithCallback(request *ListDegradeRulesOfAppRequest, callback func(response *ListDegradeRulesOfAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDegradeRulesOfAppResponse
		var err error
		defer close(result)
		response, err = client.ListDegradeRulesOfApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDegradeRulesOfAppRequest is the request struct for api ListDegradeRulesOfApp
type ListDegradeRulesOfAppRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
}

// ListDegradeRulesOfAppResponse is the response struct for api ListDegradeRulesOfApp
type ListDegradeRulesOfAppResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListDegradeRulesOfAppRequest creates a request to invoke ListDegradeRulesOfApp API
func CreateListDegradeRulesOfAppRequest() (request *ListDegradeRulesOfAppRequest) {
	request = &ListDegradeRulesOfAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListDegradeRulesOfApp", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDegradeRulesOfAppResponse creates a response to parse from ListDegradeRulesOfApp response
func CreateListDegradeRulesOfAppResponse() (response *ListDegradeRulesOfAppResponse) {
	response = &ListDegradeRulesOfAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
