package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMembers invokes the aiworkspace.ListMembers API synchronously
func (client *Client) ListMembers(request *ListMembersRequest) (response *ListMembersResponse, err error) {
	response = CreateListMembersResponse()
	err = client.DoAction(request, response)
	return
}

// ListMembersWithChan invokes the aiworkspace.ListMembers API asynchronously
func (client *Client) ListMembersWithChan(request *ListMembersRequest) (<-chan *ListMembersResponse, <-chan error) {
	responseChan := make(chan *ListMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMembersWithCallback invokes the aiworkspace.ListMembers API asynchronously
func (client *Client) ListMembersWithCallback(request *ListMembersRequest, callback func(response *ListMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMembersResponse
		var err error
		defer close(result)
		response, err = client.ListMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMembersRequest is the request struct for api ListMembers
type ListMembersRequest struct {
	*requests.RoaRequest
	Roles       string `position:"Query" name:"Roles"`
	PageSize    string `position:"Query" name:"PageSize"`
	PageNumber  string `position:"Query" name:"PageNumber"`
	MemberName  string `position:"Query" name:"MemberName"`
	WorkspaceId string `position:"Path" name:"WorkspaceId"`
}

// ListMembersResponse is the response struct for api ListMembers
type ListMembersResponse struct {
	*responses.BaseResponse
	RequestId  string        `json:"RequestId" xml:"RequestId"`
	TotalCount int64         `json:"TotalCount" xml:"TotalCount"`
	Members    []MembersItem `json:"Members" xml:"Members"`
}

// CreateListMembersRequest creates a request to invoke ListMembers API
func CreateListMembersRequest() (request *ListMembersRequest) {
	request = &ListMembersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "ListMembers", "/api/v1/workspaces/[WorkspaceId]/members", "", "")
	request.Method = requests.GET
	return
}

// CreateListMembersResponse creates a response to parse from ListMembers response
func CreateListMembersResponse() (response *ListMembersResponse) {
	response = &ListMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
