package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmAddrAttributeInfo invokes the alidns.DescribeDnsGtmAddrAttributeInfo API synchronously
func (client *Client) DescribeDnsGtmAddrAttributeInfo(request *DescribeDnsGtmAddrAttributeInfoRequest) (response *DescribeDnsGtmAddrAttributeInfoResponse, err error) {
	response = CreateDescribeDnsGtmAddrAttributeInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmAddrAttributeInfoWithChan invokes the alidns.DescribeDnsGtmAddrAttributeInfo API asynchronously
func (client *Client) DescribeDnsGtmAddrAttributeInfoWithChan(request *DescribeDnsGtmAddrAttributeInfoRequest) (<-chan *DescribeDnsGtmAddrAttributeInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmAddrAttributeInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmAddrAttributeInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmAddrAttributeInfoWithCallback invokes the alidns.DescribeDnsGtmAddrAttributeInfo API asynchronously
func (client *Client) DescribeDnsGtmAddrAttributeInfoWithCallback(request *DescribeDnsGtmAddrAttributeInfoRequest, callback func(response *DescribeDnsGtmAddrAttributeInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmAddrAttributeInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmAddrAttributeInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmAddrAttributeInfoRequest is the request struct for api DescribeDnsGtmAddrAttributeInfo
type DescribeDnsGtmAddrAttributeInfoRequest struct {
	*requests.RpcRequest
	Addrs        string `position:"Query" name:"Addrs"`
	Type         string `position:"Query" name:"Type"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDnsGtmAddrAttributeInfoResponse is the response struct for api DescribeDnsGtmAddrAttributeInfo
type DescribeDnsGtmAddrAttributeInfoResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Addr      AddrInDescribeDnsGtmAddrAttributeInfo `json:"Addr" xml:"Addr"`
}

// CreateDescribeDnsGtmAddrAttributeInfoRequest creates a request to invoke DescribeDnsGtmAddrAttributeInfo API
func CreateDescribeDnsGtmAddrAttributeInfoRequest() (request *DescribeDnsGtmAddrAttributeInfoRequest) {
	request = &DescribeDnsGtmAddrAttributeInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmAddrAttributeInfo", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmAddrAttributeInfoResponse creates a response to parse from DescribeDnsGtmAddrAttributeInfo response
func CreateDescribeDnsGtmAddrAttributeInfoResponse() (response *DescribeDnsGtmAddrAttributeInfoResponse) {
	response = &DescribeDnsGtmAddrAttributeInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
