package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIspFlushCacheInstances invokes the alidns.DescribeIspFlushCacheInstances API synchronously
func (client *Client) DescribeIspFlushCacheInstances(request *DescribeIspFlushCacheInstancesRequest) (response *DescribeIspFlushCacheInstancesResponse, err error) {
	response = CreateDescribeIspFlushCacheInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIspFlushCacheInstancesWithChan invokes the alidns.DescribeIspFlushCacheInstances API asynchronously
func (client *Client) DescribeIspFlushCacheInstancesWithChan(request *DescribeIspFlushCacheInstancesRequest) (<-chan *DescribeIspFlushCacheInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeIspFlushCacheInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIspFlushCacheInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIspFlushCacheInstancesWithCallback invokes the alidns.DescribeIspFlushCacheInstances API asynchronously
func (client *Client) DescribeIspFlushCacheInstancesWithCallback(request *DescribeIspFlushCacheInstancesRequest, callback func(response *DescribeIspFlushCacheInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIspFlushCacheInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeIspFlushCacheInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIspFlushCacheInstancesRequest is the request struct for api DescribeIspFlushCacheInstances
type DescribeIspFlushCacheInstancesRequest struct {
	*requests.RpcRequest
	Isp          string           `position:"Query" name:"Isp"`
	OrderBy      string           `position:"Query" name:"OrderBy"`
	Type         string           `position:"Query" name:"Type"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Lang         string           `position:"Query" name:"Lang"`
	Keyword      string           `position:"Query" name:"Keyword"`
	Direction    string           `position:"Query" name:"Direction"`
}

// DescribeIspFlushCacheInstancesResponse is the response struct for api DescribeIspFlushCacheInstances
type DescribeIspFlushCacheInstancesResponse struct {
	*responses.BaseResponse
	PageSize               int                     `json:"PageSize" xml:"PageSize"`
	RequestId              string                  `json:"RequestId" xml:"RequestId"`
	PageNumber             int                     `json:"PageNumber" xml:"PageNumber"`
	TotalPages             int                     `json:"TotalPages" xml:"TotalPages"`
	TotalItems             int                     `json:"TotalItems" xml:"TotalItems"`
	IspFlushCacheInstances []IspFlushCacheInstance `json:"IspFlushCacheInstances" xml:"IspFlushCacheInstances"`
}

// CreateDescribeIspFlushCacheInstancesRequest creates a request to invoke DescribeIspFlushCacheInstances API
func CreateDescribeIspFlushCacheInstancesRequest() (request *DescribeIspFlushCacheInstancesRequest) {
	request = &DescribeIspFlushCacheInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeIspFlushCacheInstances", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIspFlushCacheInstancesResponse creates a response to parse from DescribeIspFlushCacheInstances response
func CreateDescribeIspFlushCacheInstancesResponse() (response *DescribeIspFlushCacheInstancesResponse) {
	response = &DescribeIspFlushCacheInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
