package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWsCustomizedChGeneral invokes the alinlp.GetWsCustomizedChGeneral API synchronously
func (client *Client) GetWsCustomizedChGeneral(request *GetWsCustomizedChGeneralRequest) (response *GetWsCustomizedChGeneralResponse, err error) {
	response = CreateGetWsCustomizedChGeneralResponse()
	err = client.DoAction(request, response)
	return
}

// GetWsCustomizedChGeneralWithChan invokes the alinlp.GetWsCustomizedChGeneral API asynchronously
func (client *Client) GetWsCustomizedChGeneralWithChan(request *GetWsCustomizedChGeneralRequest) (<-chan *GetWsCustomizedChGeneralResponse, <-chan error) {
	responseChan := make(chan *GetWsCustomizedChGeneralResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWsCustomizedChGeneral(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWsCustomizedChGeneralWithCallback invokes the alinlp.GetWsCustomizedChGeneral API asynchronously
func (client *Client) GetWsCustomizedChGeneralWithCallback(request *GetWsCustomizedChGeneralRequest, callback func(response *GetWsCustomizedChGeneralResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWsCustomizedChGeneralResponse
		var err error
		defer close(result)
		response, err = client.GetWsCustomizedChGeneral(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWsCustomizedChGeneralRequest is the request struct for api GetWsCustomizedChGeneral
type GetWsCustomizedChGeneralRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	OutType     string `position:"Body" name:"OutType"`
}

// GetWsCustomizedChGeneralResponse is the response struct for api GetWsCustomizedChGeneral
type GetWsCustomizedChGeneralResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWsCustomizedChGeneralRequest creates a request to invoke GetWsCustomizedChGeneral API
func CreateGetWsCustomizedChGeneralRequest() (request *GetWsCustomizedChGeneralRequest) {
	request = &GetWsCustomizedChGeneralRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWsCustomizedChGeneral", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetWsCustomizedChGeneralResponse creates a response to parse from GetWsCustomizedChGeneral response
func CreateGetWsCustomizedChGeneralResponse() (response *GetWsCustomizedChGeneralResponse) {
	response = &GetWsCustomizedChGeneralResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
