package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CoreEngine invokes the amp.CoreEngine API synchronously
func (client *Client) CoreEngine(request *CoreEngineRequest) (response *CoreEngineResponse, err error) {
	response = CreateCoreEngineResponse()
	err = client.DoAction(request, response)
	return
}

// CoreEngineWithChan invokes the amp.CoreEngine API asynchronously
func (client *Client) CoreEngineWithChan(request *CoreEngineRequest) (<-chan *CoreEngineResponse, <-chan error) {
	responseChan := make(chan *CoreEngineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CoreEngine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CoreEngineWithCallback invokes the amp.CoreEngine API asynchronously
func (client *Client) CoreEngineWithCallback(request *CoreEngineRequest, callback func(response *CoreEngineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CoreEngineResponse
		var err error
		defer close(result)
		response, err = client.CoreEngine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CoreEngineRequest is the request struct for api CoreEngine
type CoreEngineRequest struct {
	*requests.RoaRequest
	ParamList *[]string           `position:"Query" name:"ParamList"  type:"Json"`
	Param3    string              `position:"Query" name:"param3"`
	Param1    *[]CoreEngineParam1 `position:"Body" name:"Param1"  type:"Json"`
	Param2    string              `position:"Query" name:"param2"`
}

// CoreEngineParam1 is a repeated param struct in CoreEngineRequest
type CoreEngineParam1 struct {
	Param3 string `name:"Param3"`
	Param1 string `name:"Param1"`
	Param2 string `name:"Param2"`
}

// CoreEngineResponse is the response struct for api CoreEngine
type CoreEngineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"success" xml:"success"`
	Message   string `json:"message" xml:"message"`
	Code      int64  `json:"code" xml:"code"`
	Data      string `json:"data" xml:"data"`
}

// CreateCoreEngineRequest creates a request to invoke CoreEngine API
func CreateCoreEngineRequest() (request *CoreEngineRequest) {
	request = &CoreEngineRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "CoreEngine", "/getVersion/demo", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCoreEngineResponse creates a response to parse from CoreEngine response
func CreateCoreEngineResponse() (response *CoreEngineResponse) {
	response = &CoreEngineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
