package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DingAPITcY invokes the amp.DingAPITcY API synchronously
func (client *Client) DingAPITcY(request *DingAPITcYRequest) (response *DingAPITcYResponse, err error) {
	response = CreateDingAPITcYResponse()
	err = client.DoAction(request, response)
	return
}

// DingAPITcYWithChan invokes the amp.DingAPITcY API asynchronously
func (client *Client) DingAPITcYWithChan(request *DingAPITcYRequest) (<-chan *DingAPITcYResponse, <-chan error) {
	responseChan := make(chan *DingAPITcYResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DingAPITcY(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DingAPITcYWithCallback invokes the amp.DingAPITcY API asynchronously
func (client *Client) DingAPITcYWithCallback(request *DingAPITcYRequest, callback func(response *DingAPITcYResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DingAPITcYResponse
		var err error
		defer close(result)
		response, err = client.DingAPITcY(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DingAPITcYRequest is the request struct for api DingAPITcY
type DingAPITcYRequest struct {
	*requests.RoaRequest
	QueryIds string `position:"Query" name:"QueryIds"`
}

// DingAPITcYResponse is the response struct for api DingAPITcY
type DingAPITcYResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDingAPITcYRequest creates a request to invoke DingAPITcY API
func CreateDingAPITcYRequest() (request *DingAPITcYRequest) {
	request = &DingAPITcYRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "DingAPITcY", "/ding/t2y", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDingAPITcYResponse creates a response to parse from DingAPITcY response
func CreateDingAPITcYResponse() (response *DingAPITcYResponse) {
	response = &DingAPITcYResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
