package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RoaHsfMutilTest invokes the amp.RoaHsfMutilTest API synchronously
func (client *Client) RoaHsfMutilTest(request *RoaHsfMutilTestRequest) (response *RoaHsfMutilTestResponse, err error) {
	response = CreateRoaHsfMutilTestResponse()
	err = client.DoAction(request, response)
	return
}

// RoaHsfMutilTestWithChan invokes the amp.RoaHsfMutilTest API asynchronously
func (client *Client) RoaHsfMutilTestWithChan(request *RoaHsfMutilTestRequest) (<-chan *RoaHsfMutilTestResponse, <-chan error) {
	responseChan := make(chan *RoaHsfMutilTestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RoaHsfMutilTest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RoaHsfMutilTestWithCallback invokes the amp.RoaHsfMutilTest API asynchronously
func (client *Client) RoaHsfMutilTestWithCallback(request *RoaHsfMutilTestRequest, callback func(response *RoaHsfMutilTestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RoaHsfMutilTestResponse
		var err error
		defer close(result)
		response, err = client.RoaHsfMutilTest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RoaHsfMutilTestRequest is the request struct for api RoaHsfMutilTest
type RoaHsfMutilTestRequest struct {
	*requests.RoaRequest
	User RoaHsfMutilTestUser `position:"Body" name:"User"  type:"Struct"`
	Id   string              `position:"Body" name:"Id"`
}

// RoaHsfMutilTestUser is a repeated param struct in RoaHsfMutilTestRequest
type RoaHsfMutilTestUser struct {
	Name string `name:"Name"`
}

// RoaHsfMutilTestResponse is the response struct for api RoaHsfMutilTest
type RoaHsfMutilTestResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateRoaHsfMutilTestRequest creates a request to invoke RoaHsfMutilTest API
func CreateRoaHsfMutilTestRequest() (request *RoaHsfMutilTestRequest) {
	request = &RoaHsfMutilTestRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "RoaHsfMutilTest", "/roefe/efe", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRoaHsfMutilTestResponse creates a response to parse from RoaHsfMutilTest response
func CreateRoaHsfMutilTestResponse() (response *RoaHsfMutilTestResponse) {
	response = &RoaHsfMutilTestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
