package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestRoaTc invokes the amp.TestRoaTc API synchronously
func (client *Client) TestRoaTc(request *TestRoaTcRequest) (response *TestRoaTcResponse, err error) {
	response = CreateTestRoaTcResponse()
	err = client.DoAction(request, response)
	return
}

// TestRoaTcWithChan invokes the amp.TestRoaTc API asynchronously
func (client *Client) TestRoaTcWithChan(request *TestRoaTcRequest) (<-chan *TestRoaTcResponse, <-chan error) {
	responseChan := make(chan *TestRoaTcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestRoaTc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestRoaTcWithCallback invokes the amp.TestRoaTc API asynchronously
func (client *Client) TestRoaTcWithCallback(request *TestRoaTcRequest, callback func(response *TestRoaTcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestRoaTcResponse
		var err error
		defer close(result)
		response, err = client.TestRoaTc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestRoaTcRequest is the request struct for api TestRoaTc
type TestRoaTcRequest struct {
	*requests.RoaRequest
}

// TestRoaTcResponse is the response struct for api TestRoaTc
type TestRoaTcResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateTestRoaTcRequest creates a request to invoke TestRoaTc API
func CreateTestRoaTcRequest() (request *TestRoaTcRequest) {
	request = &TestRoaTcRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "TestRoaTc", "/roa/tc", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTestRoaTcResponse creates a response to parse from TestRoaTc response
func CreateTestRoaTcResponse() (response *TestRoaTcResponse) {
	response = &TestRoaTcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
