package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSurveyJobs invokes the apds.ListSurveyJobs API synchronously
func (client *Client) ListSurveyJobs(request *ListSurveyJobsRequest) (response *ListSurveyJobsResponse, err error) {
	response = CreateListSurveyJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSurveyJobsWithChan invokes the apds.ListSurveyJobs API asynchronously
func (client *Client) ListSurveyJobsWithChan(request *ListSurveyJobsRequest) (<-chan *ListSurveyJobsResponse, <-chan error) {
	responseChan := make(chan *ListSurveyJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSurveyJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSurveyJobsWithCallback invokes the apds.ListSurveyJobs API asynchronously
func (client *Client) ListSurveyJobsWithCallback(request *ListSurveyJobsRequest, callback func(response *ListSurveyJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSurveyJobsResponse
		var err error
		defer close(result)
		response, err = client.ListSurveyJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSurveyJobsRequest is the request struct for api ListSurveyJobs
type ListSurveyJobsRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// ListSurveyJobsResponse is the response struct for api ListSurveyJobs
type ListSurveyJobsResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateListSurveyJobsRequest creates a request to invoke ListSurveyJobs API
func CreateListSurveyJobsRequest() (request *ListSurveyJobsRequest) {
	request = &ListSurveyJobsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "ListSurveyJobs", "/okss-services/winback/query-survey-jobs", "", "")
	request.Method = requests.POST
	return
}

// CreateListSurveyJobsResponse creates a response to parse from ListSurveyJobs response
func CreateListSurveyJobsResponse() (response *ListSurveyJobsResponse) {
	response = &ListSurveyJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
