package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSurveyResourceTypes invokes the apds.ListSurveyResourceTypes API synchronously
func (client *Client) ListSurveyResourceTypes(request *ListSurveyResourceTypesRequest) (response *ListSurveyResourceTypesResponse, err error) {
	response = CreateListSurveyResourceTypesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSurveyResourceTypesWithChan invokes the apds.ListSurveyResourceTypes API asynchronously
func (client *Client) ListSurveyResourceTypesWithChan(request *ListSurveyResourceTypesRequest) (<-chan *ListSurveyResourceTypesResponse, <-chan error) {
	responseChan := make(chan *ListSurveyResourceTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSurveyResourceTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSurveyResourceTypesWithCallback invokes the apds.ListSurveyResourceTypes API asynchronously
func (client *Client) ListSurveyResourceTypesWithCallback(request *ListSurveyResourceTypesRequest, callback func(response *ListSurveyResourceTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSurveyResourceTypesResponse
		var err error
		defer close(result)
		response, err = client.ListSurveyResourceTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSurveyResourceTypesRequest is the request struct for api ListSurveyResourceTypes
type ListSurveyResourceTypesRequest struct {
	*requests.RoaRequest
	CloudType string `position:"Query" name:"cloudType"`
	Ak        string `position:"Query" name:"ak"`
	Sk        string `position:"Query" name:"sk"`
	Region    string `position:"Query" name:"region"`
}

// ListSurveyResourceTypesResponse is the response struct for api ListSurveyResourceTypes
type ListSurveyResourceTypesResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateListSurveyResourceTypesRequest creates a request to invoke ListSurveyResourceTypes API
func CreateListSurveyResourceTypesRequest() (request *ListSurveyResourceTypesRequest) {
	request = &ListSurveyResourceTypesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "ListSurveyResourceTypes", "/okss-services/winback/query-resource-type", "", "")
	request.Method = requests.POST
	return
}

// CreateListSurveyResourceTypesResponse creates a response to parse from ListSurveyResourceTypes response
func CreateListSurveyResourceTypesResponse() (response *ListSurveyResourceTypesResponse) {
	response = &ListSurveyResourceTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
