package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewAppInstanceGroup invokes the appstream_center.RenewAppInstanceGroup API synchronously
func (client *Client) RenewAppInstanceGroup(request *RenewAppInstanceGroupRequest) (response *RenewAppInstanceGroupResponse, err error) {
	response = CreateRenewAppInstanceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RenewAppInstanceGroupWithChan invokes the appstream_center.RenewAppInstanceGroup API asynchronously
func (client *Client) RenewAppInstanceGroupWithChan(request *RenewAppInstanceGroupRequest) (<-chan *RenewAppInstanceGroupResponse, <-chan error) {
	responseChan := make(chan *RenewAppInstanceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewAppInstanceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewAppInstanceGroupWithCallback invokes the appstream_center.RenewAppInstanceGroup API asynchronously
func (client *Client) RenewAppInstanceGroupWithCallback(request *RenewAppInstanceGroupRequest, callback func(response *RenewAppInstanceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewAppInstanceGroupResponse
		var err error
		defer close(result)
		response, err = client.RenewAppInstanceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewAppInstanceGroupRequest is the request struct for api RenewAppInstanceGroup
type RenewAppInstanceGroupRequest struct {
	*requests.RpcRequest
	Period             requests.Integer `position:"Query" name:"Period"`
	AutoPay            requests.Boolean `position:"Query" name:"AutoPay"`
	PromotionId        string           `position:"Query" name:"PromotionId"`
	ProductType        string           `position:"Query" name:"ProductType"`
	PeriodUnit         string           `position:"Query" name:"PeriodUnit"`
	AppInstanceGroupId string           `position:"Query" name:"AppInstanceGroupId"`
}

// RenewAppInstanceGroupResponse is the response struct for api RenewAppInstanceGroup
type RenewAppInstanceGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateRenewAppInstanceGroupRequest creates a request to invoke RenewAppInstanceGroup API
func CreateRenewAppInstanceGroupRequest() (request *RenewAppInstanceGroupRequest) {
	request = &RenewAppInstanceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "RenewAppInstanceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateRenewAppInstanceGroupResponse creates a response to parse from RenewAppInstanceGroup response
func CreateRenewAppInstanceGroupResponse() (response *RenewAppInstanceGroupResponse) {
	response = &RenewAppInstanceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
