package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIntegration invokes the arms.CreateIntegration API synchronously
func (client *Client) CreateIntegration(request *CreateIntegrationRequest) (response *CreateIntegrationResponse, err error) {
	response = CreateCreateIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIntegrationWithChan invokes the arms.CreateIntegration API asynchronously
func (client *Client) CreateIntegrationWithChan(request *CreateIntegrationRequest) (<-chan *CreateIntegrationResponse, <-chan error) {
	responseChan := make(chan *CreateIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIntegrationWithCallback invokes the arms.CreateIntegration API asynchronously
func (client *Client) CreateIntegrationWithCallback(request *CreateIntegrationRequest, callback func(response *CreateIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIntegrationResponse
		var err error
		defer close(result)
		response, err = client.CreateIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIntegrationRequest is the request struct for api CreateIntegration
type CreateIntegrationRequest struct {
	*requests.RpcRequest
	AutoRecover            requests.Boolean `position:"Body" name:"AutoRecover"`
	RecoverTime            requests.Integer `position:"Body" name:"RecoverTime"`
	IntegrationName        string           `position:"Body" name:"IntegrationName"`
	Description            string           `position:"Body" name:"Description"`
	IntegrationProductType string           `position:"Body" name:"IntegrationProductType"`
}

// CreateIntegrationResponse is the response struct for api CreateIntegration
type CreateIntegrationResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Integration Integration `json:"Integration" xml:"Integration"`
}

// CreateCreateIntegrationRequest creates a request to invoke CreateIntegration API
func CreateCreateIntegrationRequest() (request *CreateIntegrationRequest) {
	request = &CreateIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreateIntegration", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIntegrationResponse creates a response to parse from CreateIntegration response
func CreateCreateIntegrationResponse() (response *CreateIntegrationResponse) {
	response = &CreateIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
