package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrUpdateEventBridgeIntegration invokes the arms.CreateOrUpdateEventBridgeIntegration API synchronously
func (client *Client) CreateOrUpdateEventBridgeIntegration(request *CreateOrUpdateEventBridgeIntegrationRequest) (response *CreateOrUpdateEventBridgeIntegrationResponse, err error) {
	response = CreateCreateOrUpdateEventBridgeIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrUpdateEventBridgeIntegrationWithChan invokes the arms.CreateOrUpdateEventBridgeIntegration API asynchronously
func (client *Client) CreateOrUpdateEventBridgeIntegrationWithChan(request *CreateOrUpdateEventBridgeIntegrationRequest) (<-chan *CreateOrUpdateEventBridgeIntegrationResponse, <-chan error) {
	responseChan := make(chan *CreateOrUpdateEventBridgeIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrUpdateEventBridgeIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrUpdateEventBridgeIntegrationWithCallback invokes the arms.CreateOrUpdateEventBridgeIntegration API asynchronously
func (client *Client) CreateOrUpdateEventBridgeIntegrationWithCallback(request *CreateOrUpdateEventBridgeIntegrationRequest, callback func(response *CreateOrUpdateEventBridgeIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrUpdateEventBridgeIntegrationResponse
		var err error
		defer close(result)
		response, err = client.CreateOrUpdateEventBridgeIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrUpdateEventBridgeIntegrationRequest is the request struct for api CreateOrUpdateEventBridgeIntegration
type CreateOrUpdateEventBridgeIntegrationRequest struct {
	*requests.RpcRequest
	AccessSecret     string           `position:"Body" name:"AccessSecret"`
	EventBusRegionId string           `position:"Body" name:"EventBusRegionId"`
	Description      string           `position:"Body" name:"Description"`
	Source           string           `position:"Body" name:"Source"`
	EventBusName     string           `position:"Body" name:"EventBusName"`
	Endpoint         string           `position:"Body" name:"Endpoint"`
	AccessKey        string           `position:"Body" name:"AccessKey"`
	Name             string           `position:"Body" name:"Name"`
	Id               requests.Integer `position:"Body" name:"Id"`
}

// CreateOrUpdateEventBridgeIntegrationResponse is the response struct for api CreateOrUpdateEventBridgeIntegration
type CreateOrUpdateEventBridgeIntegrationResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	EventBridgeIntegration EventBridgeIntegration `json:"EventBridgeIntegration" xml:"EventBridgeIntegration"`
}

// CreateCreateOrUpdateEventBridgeIntegrationRequest creates a request to invoke CreateOrUpdateEventBridgeIntegration API
func CreateCreateOrUpdateEventBridgeIntegrationRequest() (request *CreateOrUpdateEventBridgeIntegrationRequest) {
	request = &CreateOrUpdateEventBridgeIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreateOrUpdateEventBridgeIntegration", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOrUpdateEventBridgeIntegrationResponse creates a response to parse from CreateOrUpdateEventBridgeIntegration response
func CreateCreateOrUpdateEventBridgeIntegrationResponse() (response *CreateOrUpdateEventBridgeIntegrationResponse) {
	response = &CreateOrUpdateEventBridgeIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
