package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrUpdateNotificationPolicy invokes the arms.CreateOrUpdateNotificationPolicy API synchronously
func (client *Client) CreateOrUpdateNotificationPolicy(request *CreateOrUpdateNotificationPolicyRequest) (response *CreateOrUpdateNotificationPolicyResponse, err error) {
	response = CreateCreateOrUpdateNotificationPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrUpdateNotificationPolicyWithChan invokes the arms.CreateOrUpdateNotificationPolicy API asynchronously
func (client *Client) CreateOrUpdateNotificationPolicyWithChan(request *CreateOrUpdateNotificationPolicyRequest) (<-chan *CreateOrUpdateNotificationPolicyResponse, <-chan error) {
	responseChan := make(chan *CreateOrUpdateNotificationPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrUpdateNotificationPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrUpdateNotificationPolicyWithCallback invokes the arms.CreateOrUpdateNotificationPolicy API asynchronously
func (client *Client) CreateOrUpdateNotificationPolicyWithCallback(request *CreateOrUpdateNotificationPolicyRequest, callback func(response *CreateOrUpdateNotificationPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrUpdateNotificationPolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateOrUpdateNotificationPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrUpdateNotificationPolicyRequest is the request struct for api CreateOrUpdateNotificationPolicy
type CreateOrUpdateNotificationPolicyRequest struct {
	*requests.RpcRequest
	EscalationPolicyId requests.Integer `position:"Body" name:"EscalationPolicyId"`
	SendRecoverMessage requests.Boolean `position:"Body" name:"SendRecoverMessage"`
	IntegrationId      requests.Integer `position:"Body" name:"IntegrationId"`
	ProxyUserId        string           `position:"Body" name:"ProxyUserId"`
	MatchingRules      string           `position:"Body" name:"MatchingRules"`
	AreaCodes          string           `position:"Body" name:"AreaCodes"`
	GroupRule          string           `position:"Body" name:"GroupRule"`
	Repeat             requests.Boolean `position:"Body" name:"Repeat"`
	Name               string           `position:"Body" name:"Name"`
	Id                 requests.Integer `position:"Body" name:"Id"`
	NotifyRule         string           `position:"Body" name:"NotifyRule"`
	NotifyTemplate     string           `position:"Body" name:"NotifyTemplate"`
	RepeatInterval     requests.Integer `position:"Body" name:"RepeatInterval"`
}

// CreateOrUpdateNotificationPolicyResponse is the response struct for api CreateOrUpdateNotificationPolicy
type CreateOrUpdateNotificationPolicyResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	NotificationPolicy NotificationPolicy `json:"NotificationPolicy" xml:"NotificationPolicy"`
}

// CreateCreateOrUpdateNotificationPolicyRequest creates a request to invoke CreateOrUpdateNotificationPolicy API
func CreateCreateOrUpdateNotificationPolicyRequest() (request *CreateOrUpdateNotificationPolicyRequest) {
	request = &CreateOrUpdateNotificationPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreateOrUpdateNotificationPolicy", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOrUpdateNotificationPolicyResponse creates a response to parse from CreateOrUpdateNotificationPolicy response
func CreateCreateOrUpdateNotificationPolicyResponse() (response *CreateOrUpdateNotificationPolicyResponse) {
	response = &CreateOrUpdateNotificationPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
