package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePrometheusInstance invokes the arms.CreatePrometheusInstance API synchronously
func (client *Client) CreatePrometheusInstance(request *CreatePrometheusInstanceRequest) (response *CreatePrometheusInstanceResponse, err error) {
	response = CreateCreatePrometheusInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePrometheusInstanceWithChan invokes the arms.CreatePrometheusInstance API asynchronously
func (client *Client) CreatePrometheusInstanceWithChan(request *CreatePrometheusInstanceRequest) (<-chan *CreatePrometheusInstanceResponse, <-chan error) {
	responseChan := make(chan *CreatePrometheusInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePrometheusInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePrometheusInstanceWithCallback invokes the arms.CreatePrometheusInstance API asynchronously
func (client *Client) CreatePrometheusInstanceWithCallback(request *CreatePrometheusInstanceRequest, callback func(response *CreatePrometheusInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePrometheusInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreatePrometheusInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePrometheusInstanceRequest is the request struct for api CreatePrometheusInstance
type CreatePrometheusInstanceRequest struct {
	*requests.RpcRequest
	GrafanaInstanceId     string                          `position:"Query" name:"GrafanaInstanceId"`
	AllSubClustersSuccess requests.Boolean                `position:"Query" name:"AllSubClustersSuccess"`
	ClusterName           string                          `position:"Query" name:"ClusterName"`
	SecurityGroupId       string                          `position:"Query" name:"SecurityGroupId"`
	ClusterId             string                          `position:"Query" name:"ClusterId"`
	Tags                  *[]CreatePrometheusInstanceTags `position:"Query" name:"Tags"  type:"Repeated"`
	ClusterType           string                          `position:"Query" name:"ClusterType"`
	VSwitchId             string                          `position:"Query" name:"VSwitchId"`
	ResourceGroupId       string                          `position:"Query" name:"ResourceGroupId"`
	VpcId                 string                          `position:"Query" name:"VpcId"`
	SubClustersJson       string                          `position:"Query" name:"SubClustersJson"`
}

// CreatePrometheusInstanceTags is a repeated param struct in CreatePrometheusInstanceRequest
type CreatePrometheusInstanceTags struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreatePrometheusInstanceResponse is the response struct for api CreatePrometheusInstance
type CreatePrometheusInstanceResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateCreatePrometheusInstanceRequest creates a request to invoke CreatePrometheusInstance API
func CreateCreatePrometheusInstanceRequest() (request *CreatePrometheusInstanceRequest) {
	request = &CreatePrometheusInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreatePrometheusInstance", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePrometheusInstanceResponse creates a response to parse from CreatePrometheusInstance response
func CreateCreatePrometheusInstanceResponse() (response *CreatePrometheusInstanceResponse) {
	response = &CreatePrometheusInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
