package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAvatarList invokes the avatar.QueryAvatarList API synchronously
func (client *Client) QueryAvatarList(request *QueryAvatarListRequest) (response *QueryAvatarListResponse, err error) {
	response = CreateQueryAvatarListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAvatarListWithChan invokes the avatar.QueryAvatarList API asynchronously
func (client *Client) QueryAvatarListWithChan(request *QueryAvatarListRequest) (<-chan *QueryAvatarListResponse, <-chan error) {
	responseChan := make(chan *QueryAvatarListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAvatarList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAvatarListWithCallback invokes the avatar.QueryAvatarList API asynchronously
func (client *Client) QueryAvatarListWithCallback(request *QueryAvatarListRequest, callback func(response *QueryAvatarListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAvatarListResponse
		var err error
		defer close(result)
		response, err = client.QueryAvatarList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAvatarListRequest is the request struct for api QueryAvatarList
type QueryAvatarListRequest struct {
	*requests.RpcRequest
	ModelType    string           `position:"Query" name:"ModelType"`
	PageNo       requests.Integer `position:"Query" name:"PageNo"`
	TenantId     requests.Integer `position:"Query" name:"TenantId"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	ExtParamsCLS string           `position:"Query" name:"ExtParams_CLS"`
	ExtParams    string           `position:"Query" name:"ExtParams"`
}

// QueryAvatarListResponse is the response struct for api QueryAvatarList
type QueryAvatarListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryAvatarListRequest creates a request to invoke QueryAvatarList API
func CreateQueryAvatarListRequest() (request *QueryAvatarListRequest) {
	request = &QueryAvatarListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "QueryAvatarList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryAvatarListResponse creates a response to parse from QueryAvatarList response
func CreateQueryAvatarListResponse() (response *QueryAvatarListResponse) {
	response = &QueryAvatarListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
