package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpTypes invokes the biz_ipdb.DescribeIpTypes API synchronously
func (client *Client) DescribeIpTypes(request *DescribeIpTypesRequest) (response *DescribeIpTypesResponse, err error) {
	response = CreateDescribeIpTypesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpTypesWithChan invokes the biz_ipdb.DescribeIpTypes API asynchronously
func (client *Client) DescribeIpTypesWithChan(request *DescribeIpTypesRequest) (<-chan *DescribeIpTypesResponse, <-chan error) {
	responseChan := make(chan *DescribeIpTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpTypesWithCallback invokes the biz_ipdb.DescribeIpTypes API asynchronously
func (client *Client) DescribeIpTypesWithCallback(request *DescribeIpTypesRequest, callback func(response *DescribeIpTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpTypesResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpTypesRequest is the request struct for api DescribeIpTypes
type DescribeIpTypesRequest struct {
	*requests.RpcRequest
	BizLine string `position:"Query" name:"BizLine"`
}

// DescribeIpTypesResponse is the response struct for api DescribeIpTypes
type DescribeIpTypesResponse struct {
	*responses.BaseResponse
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	IpTypeSet  IpTypeSet `json:"IpTypeSet" xml:"IpTypeSet"`
}

// CreateDescribeIpTypesRequest creates a request to invoke DescribeIpTypes API
func CreateDescribeIpTypesRequest() (request *DescribeIpTypesRequest) {
	request = &DescribeIpTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "DescribeIpTypes", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeIpTypesResponse creates a response to parse from DescribeIpTypes response
func CreateDescribeIpTypesResponse() (response *DescribeIpTypesResponse) {
	response = &DescribeIpTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
