package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTransitRouteTableAggregationDetail invokes the cbn.DescribeTransitRouteTableAggregationDetail API synchronously
func (client *Client) DescribeTransitRouteTableAggregationDetail(request *DescribeTransitRouteTableAggregationDetailRequest) (response *DescribeTransitRouteTableAggregationDetailResponse, err error) {
	response = CreateDescribeTransitRouteTableAggregationDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTransitRouteTableAggregationDetailWithChan invokes the cbn.DescribeTransitRouteTableAggregationDetail API asynchronously
func (client *Client) DescribeTransitRouteTableAggregationDetailWithChan(request *DescribeTransitRouteTableAggregationDetailRequest) (<-chan *DescribeTransitRouteTableAggregationDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeTransitRouteTableAggregationDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTransitRouteTableAggregationDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTransitRouteTableAggregationDetailWithCallback invokes the cbn.DescribeTransitRouteTableAggregationDetail API asynchronously
func (client *Client) DescribeTransitRouteTableAggregationDetailWithCallback(request *DescribeTransitRouteTableAggregationDetailRequest, callback func(response *DescribeTransitRouteTableAggregationDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTransitRouteTableAggregationDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeTransitRouteTableAggregationDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTransitRouteTableAggregationDetailRequest is the request struct for api DescribeTransitRouteTableAggregationDetail
type DescribeTransitRouteTableAggregationDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                  requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                      string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount             string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                     string           `position:"Query" name:"OwnerAccount"`
	OwnerId                          requests.Integer `position:"Query" name:"OwnerId"`
	Version                          string           `position:"Query" name:"Version"`
	TransitRouteTableId              string           `position:"Query" name:"TransitRouteTableId"`
	TransitRouteTableAggregationCidr string           `position:"Query" name:"TransitRouteTableAggregationCidr"`
}

// DescribeTransitRouteTableAggregationDetailResponse is the response struct for api DescribeTransitRouteTableAggregationDetail
type DescribeTransitRouteTableAggregationDetailResponse struct {
	*responses.BaseResponse
	Count     int        `json:"Count" xml:"Count"`
	NextToken string     `json:"NextToken" xml:"NextToken"`
	Total     int        `json:"Total" xml:"Total"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeTransitRouteTableAggregationDetailRequest creates a request to invoke DescribeTransitRouteTableAggregationDetail API
func CreateDescribeTransitRouteTableAggregationDetailRequest() (request *DescribeTransitRouteTableAggregationDetailRequest) {
	request = &DescribeTransitRouteTableAggregationDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeTransitRouteTableAggregationDetail", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTransitRouteTableAggregationDetailResponse creates a response to parse from DescribeTransitRouteTableAggregationDetail response
func CreateDescribeTransitRouteTableAggregationDetailResponse() (response *DescribeTransitRouteTableAggregationDetailResponse) {
	response = &DescribeTransitRouteTableAggregationDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
