package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterTransitRouterMulticastGroupSources invokes the cbn.RegisterTransitRouterMulticastGroupSources API synchronously
func (client *Client) RegisterTransitRouterMulticastGroupSources(request *RegisterTransitRouterMulticastGroupSourcesRequest) (response *RegisterTransitRouterMulticastGroupSourcesResponse, err error) {
	response = CreateRegisterTransitRouterMulticastGroupSourcesResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterTransitRouterMulticastGroupSourcesWithChan invokes the cbn.RegisterTransitRouterMulticastGroupSources API asynchronously
func (client *Client) RegisterTransitRouterMulticastGroupSourcesWithChan(request *RegisterTransitRouterMulticastGroupSourcesRequest) (<-chan *RegisterTransitRouterMulticastGroupSourcesResponse, <-chan error) {
	responseChan := make(chan *RegisterTransitRouterMulticastGroupSourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterTransitRouterMulticastGroupSources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterTransitRouterMulticastGroupSourcesWithCallback invokes the cbn.RegisterTransitRouterMulticastGroupSources API asynchronously
func (client *Client) RegisterTransitRouterMulticastGroupSourcesWithCallback(request *RegisterTransitRouterMulticastGroupSourcesRequest, callback func(response *RegisterTransitRouterMulticastGroupSourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterTransitRouterMulticastGroupSourcesResponse
		var err error
		defer close(result)
		response, err = client.RegisterTransitRouterMulticastGroupSources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterTransitRouterMulticastGroupSourcesRequest is the request struct for api RegisterTransitRouterMulticastGroupSources
type RegisterTransitRouterMulticastGroupSourcesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                    string           `position:"Query" name:"ClientToken"`
	NetworkInterfaceIds            *[]string        `position:"Query" name:"NetworkInterfaceIds"  type:"Repeated"`
	TransitRouterMulticastDomainId string           `position:"Query" name:"TransitRouterMulticastDomainId"`
	ConnectPeerIds                 *[]string        `position:"Query" name:"ConnectPeerIds"  type:"Repeated"`
	GroupIpAddress                 string           `position:"Query" name:"GroupIpAddress"`
	DryRun                         requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount           string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                   string           `position:"Query" name:"OwnerAccount"`
	OwnerId                        requests.Integer `position:"Query" name:"OwnerId"`
	Version                        string           `position:"Query" name:"Version"`
	VpcId                          string           `position:"Query" name:"VpcId"`
}

// RegisterTransitRouterMulticastGroupSourcesResponse is the response struct for api RegisterTransitRouterMulticastGroupSources
type RegisterTransitRouterMulticastGroupSourcesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRegisterTransitRouterMulticastGroupSourcesRequest creates a request to invoke RegisterTransitRouterMulticastGroupSources API
func CreateRegisterTransitRouterMulticastGroupSourcesRequest() (request *RegisterTransitRouterMulticastGroupSourcesRequest) {
	request = &RegisterTransitRouterMulticastGroupSourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "RegisterTransitRouterMulticastGroupSources", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRegisterTransitRouterMulticastGroupSourcesResponse creates a response to parse from RegisterTransitRouterMulticastGroupSources response
func CreateRegisterTransitRouterMulticastGroupSourcesResponse() (response *RegisterTransitRouterMulticastGroupSourcesResponse) {
	response = &RegisterTransitRouterMulticastGroupSourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
