package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LockCards invokes the cc5g.LockCards API synchronously
func (client *Client) LockCards(request *LockCardsRequest) (response *LockCardsResponse, err error) {
	response = CreateLockCardsResponse()
	err = client.DoAction(request, response)
	return
}

// LockCardsWithChan invokes the cc5g.LockCards API asynchronously
func (client *Client) LockCardsWithChan(request *LockCardsRequest) (<-chan *LockCardsResponse, <-chan error) {
	responseChan := make(chan *LockCardsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LockCards(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LockCardsWithCallback invokes the cc5g.LockCards API asynchronously
func (client *Client) LockCardsWithCallback(request *LockCardsRequest, callback func(response *LockCardsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LockCardsResponse
		var err error
		defer close(result)
		response, err = client.LockCards(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LockCardsRequest is the request struct for api LockCards
type LockCardsRequest struct {
	*requests.RpcRequest
	Iccids      *[]string        `position:"Query" name:"Iccids"  type:"Repeated"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken string           `position:"Query" name:"ClientToken"`
}

// LockCardsResponse is the response struct for api LockCards
type LockCardsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateLockCardsRequest creates a request to invoke LockCards API
func CreateLockCardsRequest() (request *LockCardsRequest) {
	request = &LockCardsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "LockCards", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLockCardsResponse creates a response to parse from LockCards response
func CreateLockCardsResponse() (response *LockCardsResponse) {
	response = &LockCardsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
