package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomCallTagging invokes the ccc.DeleteCustomCallTagging API synchronously
func (client *Client) DeleteCustomCallTagging(request *DeleteCustomCallTaggingRequest) (response *DeleteCustomCallTaggingResponse, err error) {
	response = CreateDeleteCustomCallTaggingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomCallTaggingWithChan invokes the ccc.DeleteCustomCallTagging API asynchronously
func (client *Client) DeleteCustomCallTaggingWithChan(request *DeleteCustomCallTaggingRequest) (<-chan *DeleteCustomCallTaggingResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomCallTaggingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomCallTagging(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomCallTaggingWithCallback invokes the ccc.DeleteCustomCallTagging API asynchronously
func (client *Client) DeleteCustomCallTaggingWithCallback(request *DeleteCustomCallTaggingRequest, callback func(response *DeleteCustomCallTaggingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomCallTaggingResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomCallTagging(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomCallTaggingRequest is the request struct for api DeleteCustomCallTagging
type DeleteCustomCallTaggingRequest struct {
	*requests.RpcRequest
	Number     string `position:"Query" name:"Number"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteCustomCallTaggingResponse is the response struct for api DeleteCustomCallTagging
type DeleteCustomCallTaggingResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
}

// CreateDeleteCustomCallTaggingRequest creates a request to invoke DeleteCustomCallTagging API
func CreateDeleteCustomCallTaggingRequest() (request *DeleteCustomCallTaggingRequest) {
	request = &DeleteCustomCallTaggingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "DeleteCustomCallTagging", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCustomCallTaggingResponse creates a response to parse from DeleteCustomCallTagging response
func CreateDeleteCustomCallTaggingResponse() (response *DeleteCustomCallTaggingResponse) {
	response = &DeleteCustomCallTaggingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
