package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHistoricalAgentReport invokes the ccc.ListHistoricalAgentReport API synchronously
func (client *Client) ListHistoricalAgentReport(request *ListHistoricalAgentReportRequest) (response *ListHistoricalAgentReportResponse, err error) {
	response = CreateListHistoricalAgentReportResponse()
	err = client.DoAction(request, response)
	return
}

// ListHistoricalAgentReportWithChan invokes the ccc.ListHistoricalAgentReport API asynchronously
func (client *Client) ListHistoricalAgentReportWithChan(request *ListHistoricalAgentReportRequest) (<-chan *ListHistoricalAgentReportResponse, <-chan error) {
	responseChan := make(chan *ListHistoricalAgentReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHistoricalAgentReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHistoricalAgentReportWithCallback invokes the ccc.ListHistoricalAgentReport API asynchronously
func (client *Client) ListHistoricalAgentReportWithCallback(request *ListHistoricalAgentReportRequest, callback func(response *ListHistoricalAgentReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHistoricalAgentReportResponse
		var err error
		defer close(result)
		response, err = client.ListHistoricalAgentReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHistoricalAgentReportRequest is the request struct for api ListHistoricalAgentReport
type ListHistoricalAgentReportRequest struct {
	*requests.RpcRequest
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
	StopTime    requests.Integer `position:"Query" name:"StopTime"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	AgentIdList string           `position:"Body" name:"AgentIdList"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListHistoricalAgentReportResponse is the response struct for api ListHistoricalAgentReport
type ListHistoricalAgentReportResponse struct {
	*responses.BaseResponse
	Code           string                          `json:"Code" xml:"Code"`
	HttpStatusCode int                             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                          `json:"Message" xml:"Message"`
	RequestId      string                          `json:"RequestId" xml:"RequestId"`
	Data           DataInListHistoricalAgentReport `json:"Data" xml:"Data"`
}

// CreateListHistoricalAgentReportRequest creates a request to invoke ListHistoricalAgentReport API
func CreateListHistoricalAgentReportRequest() (request *ListHistoricalAgentReportRequest) {
	request = &ListHistoricalAgentReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListHistoricalAgentReport", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListHistoricalAgentReportResponse creates a response to parse from ListHistoricalAgentReport response
func CreateListHistoricalAgentReportResponse() (response *ListHistoricalAgentReportResponse) {
	response = &ListHistoricalAgentReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
